/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.net.RobotsHonoringPolicy;
import org.archive.modules.net.Robotstxt;
import org.archive.state.StateProvider;

public class RobotsExclusionPolicy
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(RobotsExclusionPolicy.class.getName());
    private transient Type type = Type.NORMAL;
    public static final RobotsExclusionPolicy ALLOWALL = new RobotsExclusionPolicy(Type.ALLOWALL);
    public static final RobotsExclusionPolicy DENYALL = new RobotsExclusionPolicy(Type.DENYALL);
    private Robotstxt robotstxt = null;
    RobotsHonoringPolicy honoringPolicy = null;
    private String lastUsedUserAgent = null;
    private List<String> userAgentsToTest = null;

    public static RobotsExclusionPolicy policyFor(StateProvider settings, BufferedReader reader, RobotsHonoringPolicy honoringPolicy) throws IOException {
        Robotstxt robots = new Robotstxt(reader);
        return robots.allowsAll() ? ALLOWALL : new RobotsExclusionPolicy(settings, robots, honoringPolicy);
    }

    public RobotsExclusionPolicy(StateProvider context, Robotstxt robotstxt, RobotsHonoringPolicy honoringPolicy) {
        this.robotstxt = robotstxt;
        this.honoringPolicy = honoringPolicy;
        if (honoringPolicy == null) {
            return;
        }
        if (honoringPolicy.isType(context, RobotsHonoringPolicy.Type.MOST_FAVORED)) {
            this.userAgentsToTest = robotstxt.getUserAgents();
        } else if (honoringPolicy.isType(context, RobotsHonoringPolicy.Type.MOST_FAVORED_SET)) {
            this.userAgentsToTest = new ArrayList<String>();
            block0: for (String userAgent : honoringPolicy.getUserAgents(context)) {
                for (String ua : robotstxt.getUserAgents()) {
                    if (userAgent.indexOf(ua) <= -1) continue;
                    this.userAgentsToTest.add(ua);
                    continue block0;
                }
            }
        }
    }

    public RobotsExclusionPolicy(Type type) {
        this(null, null, null);
        this.type = type;
    }

    public boolean disallows(ProcessorURI curi, String userAgent) {
        if (this == ALLOWALL) {
            return false;
        }
        if (this == DENYALL) {
            return true;
        }
        if (!(!this.honoringPolicy.isType(curi, RobotsHonoringPolicy.Type.CLASSIC) && !this.honoringPolicy.isType(curi, RobotsHonoringPolicy.Type.CUSTOM) || this.lastUsedUserAgent != null && this.lastUsedUserAgent.equals(userAgent))) {
            this.lastUsedUserAgent = userAgent;
            this.userAgentsToTest = new ArrayList<String>();
            Iterator<String> iter = this.robotstxt.getUserAgents().iterator();
            String lowerCaseUserAgent = userAgent.toLowerCase();
            while (iter.hasNext()) {
                String ua = iter.next();
                if (lowerCaseUserAgent.indexOf(ua) <= -1) continue;
                this.userAgentsToTest.add(ua);
                break;
            }
        }
        boolean disallow = false;
        String ua2 = null;
        for (String ua2 : this.userAgentsToTest) {
            String path = null;
            try {
                path = curi.getUURI().getPathQuery();
            }
            catch (URIException e) {
                logger.log(Level.SEVERE, "Failed getPathQuery from " + curi, e);
                disallow = false;
                break;
            }
            if (this.robotstxt.getDirectivesFor(ua2).allows(path)) {
                disallow = false;
                break;
            }
            disallow = true;
        }
        if (this.honoringPolicy.shouldMasquerade(curi) && ua2 != null && !ua2.equals("")) {
            curi.setUserAgent(ua2);
        }
        return disallow;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.type.ordinal());
        if (this.type == Type.NORMAL) {
            stream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int ordinal = stream.readInt();
        this.type = Type.values()[ordinal];
        if (this.type == Type.NORMAL) {
            stream.defaultReadObject();
        }
    }

    private Object readResolve() {
        if (this.type == Type.NORMAL) {
            return this;
        }
        if (this.type == Type.ALLOWALL) {
            return ALLOWALL;
        }
        if (this.type == Type.DENYALL) {
            return DENYALL;
        }
        return null;
    }

    public float getCrawlDelay(String userAgent) {
        if (this.robotstxt == null) {
            return -1.0f;
        }
        return this.robotstxt.getDirectivesFor(userAgent).getCrawlDelay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        ALLOWALL,
        DENYALL;

    }
}

