/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.archive.modules.net.RobotsDirectives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Robotstxt
implements Serializable {
    static final long serialVersionUID = 7025386509301303890L;
    LinkedList<String> userAgents = new LinkedList();
    Map<String, RobotsDirectives> agentsToDirectives = new HashMap<String, RobotsDirectives>();
    boolean hasErrors = false;
    static RobotsDirectives NO_DIRECTIVES = new RobotsDirectives();

    public Robotstxt(BufferedReader reader) throws IOException {
        RobotsDirectives current = null;
        boolean hasDirectivesYet = false;
        String catchall = null;
        while (reader != null) {
            String path;
            String read;
            while ((read = reader.readLine()) != null && ((read = read.trim()).startsWith("#") || read.length() == 0)) {
            }
            if (read == null) {
                reader.close();
                reader = null;
                continue;
            }
            int commentIndex = (read = read.replaceAll("<[^>]+>", "")).indexOf("#");
            if (commentIndex > -1) {
                read = read.substring(0, commentIndex);
            }
            if ((read = read.trim()).matches("(?i)^User-agent:.*")) {
                String ua = read.substring(11).trim().toLowerCase();
                if (current == null || hasDirectivesYet) {
                    current = new RobotsDirectives();
                    hasDirectivesYet = false;
                }
                if (ua.equals("*")) {
                    catchall = ua = "";
                } else {
                    this.userAgents.addLast(ua);
                }
                this.agentsToDirectives.put(ua, current);
                continue;
            }
            if (read.matches("(?i)Disallow:.*")) {
                if (current == null) {
                    this.hasErrors = true;
                    continue;
                }
                path = read.substring(9).trim();
                current.addDisallow(path);
                hasDirectivesYet = true;
                continue;
            }
            if (read.matches("(?i)Crawl-delay:.*")) {
                if (current == null) {
                    this.hasErrors = true;
                    continue;
                }
                hasDirectivesYet = true;
                String val = read.substring(12).trim();
                val = val.split("[^\\d\\.]+")[0];
                try {
                    current.setCrawlDelay(Float.parseFloat(val));
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (!read.matches("(?i)Allow:.*")) continue;
            if (current == null) {
                this.hasErrors = true;
                continue;
            }
            path = read.substring(6).trim();
            current.addAllow(path);
            hasDirectivesYet = true;
        }
        if (catchall != null) {
            this.userAgents.addLast(catchall);
        }
    }

    public boolean allowsAll() {
        return this.agentsToDirectives.isEmpty();
    }

    public List<String> getUserAgents() {
        return this.userAgents;
    }

    public RobotsDirectives getDirectivesFor(String ua) {
        for (String uaListed : this.userAgents) {
            if (ua.indexOf(uaListed) <= -1) continue;
            return this.agentsToDirectives.get(uaListed);
        }
        return NO_DIRECTIVES;
    }
}

