/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.net.UURI;

public class ServerCacheUtil {
    private static Logger logger = Logger.getLogger(ServerCacheUtil.class.getName());

    private ServerCacheUtil() {
    }

    public static CrawlHost getHostFor(ServerCache cache, UURI uuri) {
        try {
            return cache.getHostFor(uuri.getReferencedHost());
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, uuri.toString(), e);
            return null;
        }
    }

    public static CrawlServer getServerFor(ServerCache cache, UURI uuri) {
        CrawlServer cs = null;
        try {
            String key = CrawlServer.getServerKey(uuri);
            if (key != null) {
                cs = cache.getServerFor(key);
            }
        }
        catch (URIException e) {
            logger.log(Level.FINE, "No server key obtainable: " + uuri.toString(), e);
        }
        catch (NullPointerException npe) {
            logger.log(Level.FINE, "No server key obtainable: " + uuri.toString(), npe);
        }
        return cs;
    }
}

