/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Expert;
import org.archive.state.Key;
import org.archive.state.KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchHistoryProcessor
extends Processor {
    private static final long serialVersionUID = 8476621038669163983L;
    @Expert
    public static final Key<Integer> HISTORY_LENGTH = Key.make((int)2);

    @Override
    protected void innerProcess(ProcessorURI curi) throws InterruptedException {
        HashMap[] history;
        curi.addPersistentDataMapKey("fetch-history");
        HashMap<String, Object> latestFetch = new HashMap<String, Object>();
        latestFetch.put("status", curi.getFetchStatus());
        latestFetch.put("fetch-began-time", curi.getData().get("fetch-began-time"));
        String digest = curi.getContentDigestSchemeString();
        if (digest != null) {
            latestFetch.put("content-digest", digest);
        }
        if (curi.containsDataKey("http-transaction")) {
            HttpMethodBase method = (HttpMethodBase)curi.getData().get("http-transaction");
            this.saveHeader("etag", method, latestFetch);
            this.saveHeader("last-modified", method, latestFetch);
            long referenceLength = curi.containsDataKey("reference-length") ? ((Long)curi.getData().get("reference-length")).longValue() : curi.getContentLength();
            latestFetch.put("reference-length", referenceLength);
        }
        int targetHistoryLength = (Integer)curi.get(this, HISTORY_LENGTH);
        Object object = history = curi.containsDataKey("fetch-history") ? curi.getData().get("fetch-history") : new HashMap[targetHistoryLength];
        if (history.length != targetHistoryLength) {
            HashMap[] newHistory = new HashMap[targetHistoryLength];
            System.arraycopy(history, 0, newHistory, 0, Math.min(history.length, newHistory.length));
            history = newHistory;
        }
        for (int i = history.length - 1; i > 0; --i) {
            history[i] = history[i - 1];
        }
        history[0] = latestFetch;
        curi.getData().put("fetch-history", history);
    }

    protected void saveHeader(String name, HttpMethodBase method, HashMap<String, Object> latestFetch) {
        Header header = method.getResponseHeader(name);
        if (header != null) {
            latestFetch.put(name, header.getValue());
        }
    }

    @Override
    protected boolean shouldProcess(ProcessorURI uri) {
        return true;
    }

    static {
        KeyManager.addKeys(FetchHistoryProcessor.class);
    }
}

