/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.SerializationUtils;
import org.archive.io.CrawlerJournal;
import org.archive.modules.ProcessorURI;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.settings.Finishable;
import org.archive.settings.RecoverAction;
import org.archive.settings.file.Checkpointable;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistLogProcessor
extends PersistProcessor
implements Checkpointable,
Initializable,
Finishable {
    private static final long serialVersionUID = 1678691994065439346L;
    protected CrawlerJournal log;
    @Immutable
    public static final Key<Path> LOG_FILE = Key.make((Path)new Path("logs/persistlog.txtser.gz"));

    public void initialTasks(StateProvider provider) {
        try {
            File logFile = ((Path)provider.get((Object)this, LOG_FILE)).toFile();
            this.log = new CrawlerJournal(logFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finalTasks(StateProvider provider) {
        this.log.close();
    }

    @Override
    protected void innerProcess(ProcessorURI curi) {
        this.log.writeLine(PersistLogProcessor.persistKeyFor(curi), " ", new String(Base64.encodeBase64((byte[])SerializationUtils.serialize((Serializable)((Serializable)((Object)curi.getData()))))));
    }

    public void checkpoint(File dir, List<RecoverAction> actions) throws IOException {
        this.log.checkpoint(dir, null);
    }

    @Override
    protected boolean shouldProcess(ProcessorURI uri) {
        return this.shouldStore(uri);
    }

    static {
        KeyManager.addKeys(PersistLogProcessor.class);
    }
}

