/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.Map;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.settings.Finishable;
import org.archive.settings.file.BdbModule;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.StateProvider;

public abstract class PersistOnlineProcessor
extends PersistProcessor
implements Initializable,
Finishable {
    private static final long serialVersionUID = -666479480942267268L;
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    @Immutable
    public static final Key<String> HISTORYDB_NAME = Key.make((String)"uri_history");
    protected BdbModule bdb;
    protected StoredSortedMap store;
    protected Database historyDb;

    public void initialTasks(StateProvider provider) {
        StoredSortedMap historyMap;
        this.bdb = (BdbModule)provider.get((Object)this, BDB);
        String dbName = (String)provider.get((Object)this, HISTORYDB_NAME);
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = PersistOnlineProcessor.historyDatabaseConfig();
            this.historyDb = this.bdb.openDatabase(dbName, dbConfig, true);
            historyMap = new StoredSortedMap(this.historyDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.store = historyMap;
    }

    public void finalTasks(StateProvider defaults) {
        try {
            this.historyDb.sync();
            this.historyDb.close();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

