/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.archive.io.CrawlerJournal;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.settings.file.BdbModule;
import org.archive.util.ArchiveUtils;
import org.archive.util.SURT;
import org.archive.util.bdbje.EnhancedEnvironment;
import org.archive.util.iterator.LineReadingIterator;

public abstract class PersistProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(PersistProcessor.class.getName());
    public static final String URI_HISTORY_DBNAME = "uri_history";

    public static BdbModule.BdbConfig historyDatabaseConfig() {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        return dbConfig;
    }

    public static String persistKeyFor(ProcessorURI curi) {
        return PersistProcessor.persistKeyFor(curi.getUURI().toString());
    }

    public static String persistKeyFor(String uri) {
        return SURT.fromURI((String)uri, (boolean)true);
    }

    protected boolean shouldStore(ProcessorURI curi) {
        return curi.isSuccess();
    }

    protected boolean shouldLoad(ProcessorURI curi) {
        return true;
    }

    public static void main(String[] args) throws DatabaseException, IOException {
        if (args.length == 2) {
            PersistProcessor.main2args(args);
        } else if (args.length == 1) {
            PersistProcessor.main1arg(args);
        } else {
            System.out.println("Arguments: ");
            System.out.println("    source [target]");
            System.out.println("...where source is either a txtser log file or BDB env dir");
            System.out.println("and target, if present, is a BDB env dir. ");
            return;
        }
    }

    private static void main2args(String[] args) throws DatabaseException, FileNotFoundException, UnsupportedEncodingException, IOException {
        File source = new File(args[0]);
        File env = new File(args[1]);
        if (!env.exists()) {
            env.mkdirs();
        }
        EnhancedEnvironment targetEnv = PersistProcessor.setupEnvironment(env);
        StoredClassCatalog classCatalog = targetEnv.getClassCatalog();
        Database historyDB = targetEnv.openDatabase(null, URI_HISTORY_DBNAME, PersistProcessor.historyDatabaseConfig().toDatabaseConfig());
        StoredSortedMap historyMap = new StoredSortedMap(historyDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        int count = 0;
        if (source.isFile()) {
            BufferedReader br = CrawlerJournal.getBufferedReader((File)source);
            LineReadingIterator iter = new LineReadingIterator(br);
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if ((line = line.trim()).length() == 0) continue;
                String[] splits = line.split(" ");
                if (splits.length != 2) {
                    logger.severe("bad line: " + line);
                    continue;
                }
                try {
                    historyMap.put((Object)splits[0], SerializationUtils.deserialize((byte[])Base64.decodeBase64((byte[])splits[1].getBytes("UTF8"))));
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "problem with line: " + line, e);
                }
                ++count;
            }
            IOUtils.closeQuietly((Reader)br);
        } else {
            EnhancedEnvironment sourceEnv = PersistProcessor.setupEnvironment(source);
            StoredClassCatalog sourceClassCatalog = sourceEnv.getClassCatalog();
            Database sourceHistoryDB = sourceEnv.openDatabase(null, URI_HISTORY_DBNAME, PersistProcessor.historyDatabaseConfig().toDatabaseConfig());
            StoredSortedMap sourceHistoryMap = new StoredSortedMap(sourceHistoryDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)sourceClassCatalog, Map.class), true);
            Iterator iter = sourceHistoryMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry item = (Map.Entry)iter.next();
                historyMap.put(item.getKey(), item.getValue());
                ++count;
            }
            StoredIterator.close(iter);
            sourceHistoryDB.close();
            sourceEnv.close();
        }
        historyDB.sync();
        historyDB.close();
        targetEnv.close();
        System.out.println(count + " records imported from " + source + " to BDB env " + env);
    }

    private static void main1arg(String[] args) throws DatabaseException, FileNotFoundException, UnsupportedEncodingException, IOException {
        File source = new File(args[0]);
        int count = 0;
        if (source.isFile()) {
            BufferedReader br = CrawlerJournal.getBufferedReader((File)source);
            LineReadingIterator iter = new LineReadingIterator(br);
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if ((line = line.trim()).length() == 0) continue;
                String[] splits = line.split(" ");
                if (splits.length != 2) {
                    logger.severe("bad line: " + line);
                    continue;
                }
                try {
                    Map alist = (Map)SerializationUtils.deserialize((byte[])Base64.decodeBase64((byte[])splits[1].getBytes("UTF8")));
                    System.out.println(splits[0] + " " + ArchiveUtils.prettyString((Map)alist));
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "problem with line: " + line, e);
                }
                ++count;
            }
            IOUtils.closeQuietly((Reader)br);
        } else {
            EnhancedEnvironment sourceEnv = PersistProcessor.setupEnvironment(source);
            StoredClassCatalog sourceClassCatalog = sourceEnv.getClassCatalog();
            Database sourceHistoryDB = sourceEnv.openDatabase(null, URI_HISTORY_DBNAME, PersistProcessor.historyDatabaseConfig().toDatabaseConfig());
            StoredSortedMap sourceHistoryMap = new StoredSortedMap(sourceHistoryDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)sourceClassCatalog, Map.class), true);
            Iterator iter = sourceHistoryMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry item = (Map.Entry)iter.next();
                Map alist = (Map)sourceHistoryMap.get(item.getKey());
                System.out.println(item.getKey() + " " + ArchiveUtils.prettyString((Map)alist));
                ++count;
            }
            StoredIterator.close(iter);
            sourceHistoryDB.close();
            sourceEnv.close();
        }
        System.out.println(count + " records dumped from " + source);
    }

    public static EnhancedEnvironment setupEnvironment(File env) throws DatabaseException {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        return new EnhancedEnvironment(env, envConfig);
    }
}

