/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.seeds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexpLineIterator;
import org.archive.util.iterator.TransformingIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedFileIterator
extends TransformingIteratorWrapper<String, UURI> {
    private static Logger logger = Logger.getLogger(SeedFileIterator.class.getName());
    BufferedReader input;
    Writer ignored;

    public SeedFileIterator(BufferedReader br) {
        this(br, null);
    }

    public SeedFileIterator(BufferedReader inputReader, Writer ignoredWriter) {
        this.inner = new RegexpLineIterator((Iterator)new LineReadingIterator(inputReader), "\\s*(#.*)?", "^\\s*(\\S+)\\s*(#.*)?$", "$1");
        this.input = inputReader;
        this.ignored = ignoredWriter;
    }

    protected UURI transform(String uri) {
        if (!uri.matches("[a-zA-Z][\\w+\\-]+:.*")) {
            uri = "http://" + uri;
        }
        try {
            return UURIFactory.getInstance((String)uri);
        }
        catch (URIException e) {
            logger.log(Level.INFO, "line in seed file ignored: " + e.getMessage(), e);
            if (this.ignored != null) {
                try {
                    this.ignored.write(uri + "\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    protected void noteExhausted() {
        super.noteExhausted();
        this.close();
    }

    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.ignored != null) {
                this.ignored.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

