/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.seeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.seeds.SeedFileIterator;
import org.archive.modules.seeds.SeedListener;
import org.archive.modules.seeds.SeedModule;
import org.archive.modules.seeds.SeedRefreshListener;
import org.archive.net.UURI;
import org.archive.openmbeans.annotations.Bean;
import org.archive.openmbeans.annotations.Operation;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.RecoverAction;
import org.archive.settings.file.Checkpointable;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.DevUtils;
import org.archive.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedModuleImpl
extends Bean
implements SeedModule,
Initializable,
Serializable,
KeyChangeListener,
Checkpointable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(SeedModuleImpl.class.getName());
    @Expert
    @Immutable
    public static final Key<Path> SEEDSFILE = Key.make((Path)new Path("seeds.txt"));
    @Global
    @Expert
    public static final Key<Boolean> REREAD_SEEDS_ON_CONFIG = Key.make((boolean)true);
    protected Set<SeedListener> seedListeners = new HashSet<SeedListener>();
    protected Set<SeedRefreshListener> seedRefreshListeners = new HashSet<SeedRefreshListener>();
    private Path seedsFile;

    public SeedModuleImpl() {
        super(SeedModule.class);
    }

    public void initialTasks(StateProvider provider) {
        this.seedsFile = (Path)provider.get((Object)this, SEEDSFILE);
    }

    @Override
    @Operation(desc="Notify all listeners that the seeds file has changed.")
    public void refreshSeeds() {
        this.fireSeedsRefreshed();
    }

    protected void fireSeedsRefreshed() {
        for (SeedRefreshListener l : this.seedRefreshListeners) {
            l.seedsRefreshed();
        }
    }

    public File getSeedfile() {
        return this.seedsFile.toFile();
    }

    protected boolean isSeed(Object o) {
        return o instanceof ProcessorURI && ((ProcessorURI)o).isSeed();
    }

    protected boolean isSameHost(UURI a, UURI b) {
        boolean isSameHost = false;
        if (a != null && b != null) {
            try {
                if (a.getReferencedHost() != null && b.getReferencedHost() != null && a.getReferencedHost().equals(b.getReferencedHost())) {
                    isSameHost = true;
                }
            }
            catch (URIException e) {
                logger.severe("Failed compare of " + a + " " + b + ": " + e.getMessage());
            }
        }
        return isSameHost;
    }

    public void listUsedFiles(List<String> list) {
        File file = this.getSeedfile();
        list.add(file.getAbsolutePath());
    }

    public void keyChanged(KeyChangeEvent event) {
        StateProvider context = event.getStateProvider();
        if (((Boolean)context.get((Object)this, REREAD_SEEDS_ON_CONFIG)).booleanValue()) {
            this.refreshSeeds();
        }
    }

    public Iterator<UURI> seedsIterator() {
        return this.seedsIterator(null);
    }

    public Iterator<UURI> seedsIterator(Writer ignoredItemWriter) {
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(this.getSeedfile()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new SeedFileIterator(br, ignoredItemWriter);
    }

    protected void checkClose(Iterator<?> iter) {
        if (iter instanceof SeedFileIterator) {
            ((SeedFileIterator)((Object)iter)).close();
        }
    }

    public boolean addSeed(ProcessorURI curi) {
        File f = this.getSeedfile();
        if (f != null) {
            try {
                FileWriter fw = new FileWriter(f, true);
                fw.write("\n");
                fw.write("# Heritrix added seed " + (curi.getVia() != null ? "redirect from " + curi.getVia() : "(JMX)") + ".\n");
                fw.write(curi.toString());
                fw.flush();
                fw.close();
                Iterator<SeedListener> iter = this.seedListeners.iterator();
                while (iter.hasNext()) {
                    iter.next().addedSeed(curi);
                }
                return true;
            }
            catch (IOException e) {
                DevUtils.warnHandle((Throwable)e, (String)"problem writing new seed");
            }
        }
        return false;
    }

    public void addSeedListener(SeedListener sl) {
        this.seedListeners.add(sl);
    }

    public void addSeedRefreshListener(SeedRefreshListener srl) {
        this.seedRefreshListeners.add(srl);
    }

    public void checkpoint(File dir, List<RecoverAction> actions) throws IOException {
        int id = System.identityHashCode(this);
        String backup = "seeds" + id + " .txt";
        FileUtils.copyFile((File)this.getSeedfile(), (File)new File(dir, backup));
        actions.add(new SeedModuleRecoverAction(backup, this.getSeedfile()));
    }

    static {
        KeyManager.addKeys(SeedModuleImpl.class);
    }

    private static class SeedModuleRecoverAction
    implements RecoverAction {
        private static final long serialVersionUID = 1L;
        private File target;
        private String backup;

        public SeedModuleRecoverAction(String backup, File target) {
            this.target = target;
            this.backup = backup;
        }

        public void recoverFrom(File checkpointDir, CheckpointRecovery cr) throws Exception {
            this.target = new File(cr.translatePath(this.target.getAbsolutePath()));
            FileUtils.copyFile((File)new File(checkpointDir, this.backup), (File)this.target);
        }
    }
}

