/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;
import org.archive.io.ReplayInputStream;
import org.archive.io.WriterPool;
import org.archive.io.WriterPoolMember;
import org.archive.io.WriterPoolSettings;
import org.archive.io.arc.ARCWriter;
import org.archive.io.arc.ARCWriterPool;
import org.archive.modules.ProcessResult;
import org.archive.modules.ProcessorURI;
import org.archive.modules.writer.MetadataProvider;
import org.archive.modules.writer.WriterPoolProcessor;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARCWriterProcessor
extends WriterPoolProcessor {
    private static final String TEMPLATE = ARCWriterProcessor.readTemplate();
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(ARCWriterProcessor.class.getName());
    private static final String[] DEFAULT_PATH = new String[]{"arcs"};
    @Global
    public static final Key<List<String>> PATH = Key.makeSimpleList(String.class, (Object[])new String[]{"arcs"});
    private transient List<String> cachedMetadata;

    protected String[] getDefaultPath() {
        return DEFAULT_PATH;
    }

    @Override
    protected void setupPool(AtomicInteger serialNo) {
        int maxActive = this.getMaxActive();
        int maxWait = this.getMaxWait();
        WriterPoolSettings wps = this.getWriterPoolSettings();
        this.setPool((WriterPool)new ARCWriterPool(serialNo, wps, maxActive, maxWait));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessResult innerProcessResult(ProcessorURI puri) {
        ReplayInputStream ris;
        ProcessorURI curi;
        block5: {
            curi = puri;
            long recordLength = ARCWriterProcessor.getRecordedSize(curi);
            ris = null;
            if (!this.shouldWrite(curi)) break block5;
            ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
            ProcessResult processResult = this.write(curi, recordLength, (InputStream)ris, this.getHostAddress(curi));
            IoUtils.close((Closeable)ris);
            return processResult;
        }
        try {
            logger.info("does not write " + curi.toString());
        }
        catch (IOException e) {
            try {
                curi.getNonFatalFailures().add(e);
                logger.log(Level.SEVERE, "Failed write of Record: " + curi.toString(), e);
            }
            catch (Throwable throwable) {
                IoUtils.close(ris);
                throw throwable;
            }
            IoUtils.close((Closeable)ris);
        }
        IoUtils.close((Closeable)ris);
        return ProcessResult.PROCEED;
    }

    protected ProcessResult write(ProcessorURI curi, long recordLength, InputStream in, String ip) throws IOException {
        WriterPoolMember writer = this.getPool().borrowFile();
        long position = writer.getPosition();
        writer.checkSize();
        if (writer.getPosition() != position) {
            this.setTotalBytesWritten(this.getTotalBytesWritten() + (writer.getPosition() - position));
            position = writer.getPosition();
        }
        ARCWriter w = (ARCWriter)writer;
        try {
            if (in instanceof ReplayInputStream) {
                w.write(curi.toString(), curi.getContentType(), ip, curi.getFetchBeginTime(), recordLength, (InputStream)((ReplayInputStream)in));
            } else {
                w.write(curi.toString(), curi.getContentType(), ip, curi.getFetchBeginTime(), recordLength, in);
            }
        }
        catch (IOException e) {
            this.getPool().invalidateFile(writer);
            writer = null;
            throw e;
        }
        finally {
            if (writer != null) {
                this.setTotalBytesWritten(this.getTotalBytesWritten() + (writer.getPosition() - position));
                this.getPool().returnFile(writer);
            }
        }
        return this.checkBytesWritten(curi);
    }

    @Override
    protected Key<List<String>> getPathKey() {
        return PATH;
    }

    @Override
    protected List<String> getMetadata(StateProvider global) {
        if (TEMPLATE == null) {
            return null;
        }
        if (this.cachedMetadata != null) {
            return this.cachedMetadata;
        }
        MetadataProvider provider = (MetadataProvider)global.get((Object)this, METADATA_PROVIDER);
        String meta = TEMPLATE;
        meta = ARCWriterProcessor.replace(meta, "${VERSION}", ArchiveUtils.VERSION);
        meta = ARCWriterProcessor.replace(meta, "${HOST}", ARCWriterProcessor.getHostName());
        meta = ARCWriterProcessor.replace(meta, "${IP}", ARCWriterProcessor.getHostAddress());
        if (provider != null) {
            meta = ARCWriterProcessor.replace(meta, "${JOB_NAME}", provider.getJobName());
            meta = ARCWriterProcessor.replace(meta, "${DESCRIPTION}", provider.getJobDescription());
            meta = ARCWriterProcessor.replace(meta, "${OPERATOR}", provider.getJobOperator());
            meta = ARCWriterProcessor.replace(meta, "${USER_AGENT}", provider.getUserAgent());
            meta = ARCWriterProcessor.replace(meta, "${FROM}", provider.getFrom());
            meta = ARCWriterProcessor.replace(meta, "${ROBOTS}", provider.getRobotsPolicy());
        }
        this.cachedMetadata = Collections.singletonList(meta);
        return this.cachedMetadata;
    }

    private String GMT() {
        TimeZone gmt = TimeZone.getTimeZone("GMT+00:00");
        Calendar calendar = Calendar.getInstance(gmt);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        Date date = calendar.getTime();
        return sdf.format(date) + "+00:00";
    }

    private static String replace(String meta, String find, String replace) {
        replace = StringEscapeUtils.escapeXml((String)replace);
        return meta.replace(find, replace);
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Could not get local host name.", e);
            return "localhost";
        }
    }

    private static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Could not get local host address.", e);
            return "localhost";
        }
    }

    private static String readTemplate() {
        InputStream input = ARCWriterProcessor.class.getResourceAsStream("arc_metadata_template.xml");
        if (input == null) {
            logger.severe("No metadata template.");
            return null;
        }
        try {
            String string = IoUtils.readFullyAsString((InputStream)input);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.close((Closeable)input);
        }
    }

    static {
        KeyManager.addKeys(ARCWriterProcessor.class);
    }
}

