/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.RobotsHonoringPolicy;
import org.archive.modules.writer.MetadataProvider;
import org.archive.settings.SheetManager;
import org.archive.state.Constraint;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyMaker;
import org.archive.state.KeyManager;
import org.archive.state.Module;
import org.archive.state.PatternConstraint;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;

public class DefaultMetadataProvider
implements Initializable,
MetadataProvider,
UserAgentProvider,
Serializable,
Module {
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final Key<SheetManager> SHEET_MANAGER = Key.makeAuto(SheetManager.class);
    @Immutable
    public static final Key<RobotsHonoringPolicy> ROBOTS_HONORING_POLICY = Key.makeAuto(RobotsHonoringPolicy.class);
    @Immutable
    public static final Key<String> OPERATOR_NAME = Key.make((String)"");
    @Immutable
    public static final Key<String> DESCRIPTION = Key.make((String)"");
    public static final Key<String> HTTP_USER_AGENT = KeyMaker.make((Object)"Mozilla/5.0 (compatible; heritrix/@VERSION@ +@OPERATOR_CONTACT_URL@)").addConstraint((Constraint)new PatternConstraint(Pattern.compile("^.*\\+@OPERATOR_CONTACT_URL@.*$"))).toKey();
    public static final Key<String> OPERATOR_FROM = KeyMaker.make((Object)"").addConstraint((Constraint)new PatternConstraint(Pattern.compile("^(\\s*|\\S+@[-\\w]+\\.[-\\w\\.]+)$"))).toKey();
    public static final Key<String> OPERATOR_CONTACT_URL = KeyMaker.make((Object)"ENTER-A-CONTACT-HTTP-URL-FOR-CRAWL-OPERATOR").addConstraint((Constraint)new PatternConstraint(Pattern.compile("^https?://.*$"))).toKey();
    @Immutable
    public static final Key<String> AUDIENCE = Key.make((String)"");
    @Immutable
    public static final Key<String> ORGANIZATION = Key.make((String)"");
    private SheetManager manager;
    private String operatorName;
    private String description;
    private String robotsPolicy;
    private String userAgent;
    private String from;
    private String audience;
    private String organization;

    public void initialTasks(StateProvider global) {
        this.manager = (SheetManager)global.get((Object)this, SHEET_MANAGER);
        this.robotsPolicy = ((RobotsHonoringPolicy)global.get((Object)this, ROBOTS_HONORING_POLICY)).getType(global).toString();
        this.operatorName = (String)global.get((Object)this, OPERATOR_NAME);
        this.description = (String)global.get((Object)this, DESCRIPTION);
        this.from = (String)global.get((Object)this, OPERATOR_FROM);
        this.userAgent = this.getUserAgent(global);
        this.audience = (String)global.get((Object)this, AUDIENCE);
        this.organization = (String)global.get((Object)this, ORGANIZATION);
    }

    public String getFrom() {
        return this.from;
    }

    public String getFrom(StateProvider context) {
        return this.from;
    }

    public String getUserAgent(StateProvider context) {
        String userAgent = (String)context.get((Object)this, HTTP_USER_AGENT);
        String contactURL = (String)context.get((Object)this, OPERATOR_CONTACT_URL);
        userAgent = userAgent.replaceFirst("@OPERATOR_CONTACT_URL@", contactURL);
        userAgent = userAgent.replaceFirst("@VERSION@", Matcher.quoteReplacement(ArchiveUtils.VERSION));
        return userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getJobDescription() {
        return this.description;
    }

    public String getJobName() {
        return this.manager.getCrawlName();
    }

    public String getJobOperator() {
        return this.operatorName;
    }

    public String getRobotsPolicy() {
        return this.robotsPolicy;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getOrganization() {
        return this.organization;
    }

    static {
        KeyManager.addKeys(DefaultMetadataProvider.class);
    }
}

