/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.ReplayInputStream;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.Path;
import org.archive.state.StateProvider;

public class Kw3WriterProcessor
extends Processor
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static String COLON = ":";
    private static String WS = " ";
    private static String LF = "\n";
    private static final Logger logger = Logger.getLogger(Kw3WriterProcessor.class.getName());
    @Immutable
    public static final Key<Path> PATH = Key.make((Path)new Path("arcs"));
    @Immutable
    public static final Key<Integer> MAX_SIZE_BYTES = Key.make((int)10000000);
    @Immutable
    public static final Key<Boolean> CHMOD = Key.make((boolean)true);
    public static final Key<String> CHMOD_VALUE = Key.make((String)"777");
    public static final String ATTR_MAX_BYTES_WRITTEN = "total-bytes-to-write";
    @Immutable
    public static final Key<String> COLLECTION = Key.make((String)"kw3");
    @Immutable
    public static final Key<String> HARVESTER = Key.make((String)"heritrix");
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    private static String BOUNDARY_START = "KulturArw3_";
    private File arcsDir;
    private boolean chmod;
    private String chmodValue;
    private int maxSize;
    private String collection;
    private String harvester;
    private ServerCache serverCache;

    public void initialTasks(StateProvider global) {
        Path arcsDirPath = (Path)global.get((Object)this, PATH);
        this.arcsDir = arcsDirPath.toFile();
        this.collection = (String)global.get((Object)this, COLLECTION);
        this.harvester = (String)global.get((Object)this, HARVESTER);
        this.chmod = (Boolean)global.get((Object)this, CHMOD);
        this.chmodValue = (String)global.get((Object)this, CHMOD_VALUE);
        this.maxSize = (Integer)global.get((Object)this, MAX_SIZE_BYTES);
        this.serverCache = (ServerCache)global.get((Object)this, SERVER_CACHE);
    }

    protected boolean shouldProcess(ProcessorURI curi) {
        if (!Kw3WriterProcessor.isSuccess(curi)) {
            return false;
        }
        String scheme = curi.getUURI().getScheme().toLowerCase();
        return "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme);
    }

    protected void innerProcess(ProcessorURI curi) {
        try {
            this.writeMimeFile(curi);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "i/o error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMimeFile(ProcessorURI curi) throws IOException {
        ReplayInputStream ris = null;
        OutputStream out = null;
        try {
            String boundary = BOUNDARY_START + this.stringToMD5(curi.toString());
            ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
            out = this.initOutputStream(curi);
            this.writeArchiveInfoPart(boundary, curi, ris, out);
            this.writeHeaderPart(boundary, ris, out);
            this.writeContentPart(boundary, curi, ris, out);
            String terminator = "\n--" + boundary + "--\n";
            out.write(terminator.getBytes());
        }
        finally {
            if (ris != null) {
                ris.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    protected OutputStream initOutputStream(ProcessorURI curi) throws IOException {
        String uri = curi.toString();
        int port = curi.getUURI().getPort();
        String host = port == 80 || port <= 0 ? curi.getUURI().getHost() : curi.getUURI().getHost() + ":" + port;
        long fetchTime = curi.getFetchBeginTime() / 1000L;
        String md5 = this.stringToMD5(host);
        File dir = new File(this.arcsDir, md5.substring(0, 2) + "/" + host + "/current");
        if (!dir.exists()) {
            dir.mkdirs();
            if (this.chmod) {
                this.chmods(dir, this.arcsDir);
            }
        }
        md5 = this.stringToMD5(uri);
        File arcFile = new File(dir, md5 + "." + fetchTime);
        return new FastBufferedOutputStream((OutputStream)new FileOutputStream(arcFile));
    }

    protected void writeArchiveInfoPart(String boundary, ProcessorURI curi, ReplayInputStream ris, OutputStream out) throws IOException {
        String uri = curi.toString();
        String ip = this.getHostAddress(curi);
        long headerLength = ris.getHeaderSize();
        long contentLength = ris.getContentSize();
        long archiveTime = System.currentTimeMillis() / 1000L;
        int statusCode = curi.getFetchStatus();
        String headerMd5 = null;
        Object contentMd5 = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ris.readHeaderTo((OutputStream)baos);
        headerMd5 = this.stringToMD5(baos.toString());
        contentMd5 = curi.getContentDigest();
        if (contentMd5 != null) {
            contentMd5 = this.getHexString((byte[])contentMd5);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("MIME-version: 1.1" + LF);
        buffer.append("Content-Type: multipart/mixed; boundary=" + boundary + LF);
        buffer.append("HTTP-Part: ArchiveInfo" + LF);
        buffer.append("HTTP-Collection" + COLON + WS + this.collection + LF);
        buffer.append("HTTP-Harvester" + COLON + WS + this.harvester + LF);
        buffer.append("HTTP-URL" + COLON + WS + uri + LF);
        buffer.append("HTTP-IP-Address" + COLON + WS + ip + LF);
        buffer.append("HTTP-Header-Length" + COLON + WS + headerLength + LF);
        buffer.append("HTTP-Header-MD5" + COLON + WS + headerMd5 + LF);
        buffer.append("HTTP-Content-Length" + COLON + WS + contentLength + LF);
        buffer.append("HTTP-Content-MD5" + COLON + WS + contentMd5 + LF);
        buffer.append("HTTP-Archive-Time" + COLON + WS + archiveTime + LF);
        buffer.append("HTTP-Status-Code" + COLON + WS + statusCode + LF + LF);
        out.write(buffer.toString().getBytes());
    }

    protected void writeHeaderPart(String boundary, ReplayInputStream ris, OutputStream out) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("--" + boundary + LF);
        buffer.append("Content-Type: text/plain; charset=\"US-ascii\"" + LF);
        buffer.append("HTTP-Part: Header" + LF + LF);
        out.write(buffer.toString().getBytes());
        ris.readHeaderTo(out);
    }

    protected void writeContentPart(String boundary, ProcessorURI curi, ReplayInputStream ris, OutputStream out) throws IOException {
        String uri = curi.toString();
        String contentType = curi.getContentType();
        long contentLength = ris.getContentSize();
        if (contentLength == 0L) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("--" + boundary + LF);
        buffer.append("Content-Type: " + contentType + LF);
        buffer.append("HTTP-Part: Content" + LF + LF);
        out.write(buffer.toString().getBytes());
        if (contentLength > (long)this.maxSize) {
            ris.readContentTo(out, this.maxSize);
            logger.info(" Truncated url: " + uri + ", Size: " + contentLength + ", Content-type: " + contentType);
        } else {
            ris.readContentTo(out);
        }
    }

    private String stringToMD5(String str) {
        try {
            byte[] b = str.getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(b);
            byte[] digest = md.digest();
            return this.getHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, "md5 error", e);
            return null;
        }
    }

    private String getHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String tmp = Integer.toHexString(b[i] & 0xFF);
            if (tmp.length() < 2) {
                sb.append("0" + tmp);
                continue;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private void chmods(File dir, File arcsDir) {
        String topdir = arcsDir.getAbsolutePath();
        this.chmod(dir, this.chmodValue);
        File parent = dir.getParentFile();
        while (!parent.getAbsolutePath().equalsIgnoreCase(topdir)) {
            this.chmod(parent, this.chmodValue);
            parent = parent.getParentFile();
        }
    }

    private void chmod(File file, String permissions) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec("chmod " + permissions + " " + file.getAbsolutePath());
            proc.waitFor();
            proc.getInputStream().close();
            proc.getOutputStream().close();
            proc.getErrorStream().close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "chmod failed", e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "chmod failed", e);
        }
    }

    private String getHostAddress(ProcessorURI curi) {
        CrawlHost h = ServerCacheUtil.getHostFor(this.serverCache, curi.getUURI());
        if (h == null) {
            throw new NullPointerException("Crawlhost is null for " + curi + " " + curi.getVia());
        }
        InetAddress a = h.getIP();
        if (a == null) {
            throw new NullPointerException("Address is null for " + curi + " " + curi.getVia() + ". Address " + (h.getIpFetched() == -2L ? "was never looked up." : System.currentTimeMillis() - h.getIpFetched() + " ms ago."));
        }
        return h.getIP().getHostAddress();
    }
}

