/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import org.archive.io.RecordingInputStream;
import org.archive.io.ReplayInputStream;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.net.UURI;
import org.archive.state.Constraint;
import org.archive.state.Key;
import org.archive.state.KeyMaker;
import org.archive.state.KeyManager;
import org.archive.state.PatternConstraint;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorWriterProcessor
extends Processor {
    private static final long serialVersionUID = 3L;
    public static final String A_MIRROR_PATH = "mirror-path";
    private static final Pattern PATH_SEGMENT_RE = Pattern.compile("[^\\" + File.separator + "]+");
    private static final Pattern TOO_LONG_DIRECTORY_RE = Pattern.compile("[^\\" + File.separator + "].*");
    public static final Key<Boolean> CASE_SENSITIVE = Key.make((boolean)true);
    public static final Key<List<String>> CHARACTER_MAP = Key.makeList(String.class);
    public static final Key<List<String>> CONTENT_TYPE_MAP = Key.makeList(String.class);
    public static final Key<String> DOT_BEGIN = MirrorWriterProcessor.makePatterned("%2E", PATH_SEGMENT_RE);
    public static final Key<String> DOT_END = MirrorWriterProcessor.makePatterned(".", PATH_SEGMENT_RE);
    public static final Key<String> DIRECTORY_FILE = MirrorWriterProcessor.makePatterned("index.html", PATH_SEGMENT_RE);
    public static final Key<Boolean> HOST_DIRECTORY = Key.make((boolean)true);
    public static final Key<List<String>> HOST_MAP = Key.makeList(String.class);
    public static final Key<Integer> MAX_PATH_LENGTH = Key.make((int)1023);
    public static final Key<Integer> MAX_SEG_LEN = Key.make((int)255);
    public static final Key<String> PATH = Key.make((String)"mirror");
    public static final Key<Boolean> PORT_DIRECTORY = Key.make((boolean)false);
    public static final Key<Boolean> SUFFIX_AT_END = Key.make((boolean)true);
    public static final Key<String> TOO_LONG_DIRECTORY = MirrorWriterProcessor.makePatterned("LONG", TOO_LONG_DIRECTORY_RE);
    public static final Key<List<String>> UNDERSCORE_SET = Key.makeList(String.class);
    private static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final Logger logger = Logger.getLogger(MirrorWriterProcessor.class.getName());

    @Override
    protected boolean shouldProcess(ProcessorURI curi) {
        return MirrorWriterProcessor.isSuccess(curi);
    }

    @Override
    protected void innerProcess(ProcessorURI curi) {
        UURI uuri = curi.getUURI();
        String scheme = uuri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return;
        }
        RecordingInputStream recis = curi.getRecorder().getRecordedInput();
        if (0L == recis.getResponseContentLength()) {
            return;
        }
        String baseDir = null;
        String baseSeg = (String)curi.get(this, PATH);
        baseDir = new File(".").getPath();
        while (baseSeg.length() > 1 && baseSeg.endsWith(File.separator)) {
            baseSeg = baseSeg.substring(0, baseSeg.length() - 1);
        }
        baseDir = 0 == baseSeg.length() ? new File(".").getPath() : (new File(baseSeg).isAbsolute() ? baseSeg : new File(".").getPath() + File.separator + baseSeg);
        boolean reCrawl = curi.getData().containsKey(A_MIRROR_PATH);
        String mps = null;
        File destFile = null;
        try {
            if (reCrawl) {
                mps = (String)curi.getData().get(A_MIRROR_PATH);
                destFile = new File(baseDir + File.separator + mps);
                File parent = destFile.getParentFile();
                if (null != parent) {
                    IoUtils.ensureWriteableDirectory((File)parent);
                }
            } else {
                URIToFileReturn r = null;
                try {
                    r = this.uriToFile(baseDir, curi);
                }
                catch (AttributeNotFoundException e) {
                    logger.warning(e.getLocalizedMessage());
                    return;
                }
                destFile = r.getFile();
                mps = r.getRelativePath();
            }
            logger.info(uuri.toString() + " -> " + destFile.getPath());
            this.writeToPath(recis, destFile);
            if (!reCrawl) {
                curi.getData().put(A_MIRROR_PATH, mps);
            }
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
    }

    private URIToFileReturn dirPath(String baseDir, String host, int port, PathSegment[] segs, int maxLen) throws IOException {
        URIToFileReturn r = new URIToFileReturn(baseDir, host, port);
        r.mkdirs();
        for (int i = 0; segs.length - 1 != i; ++i) {
            segs[i].addToPath(r);
            if (!r.longerThan(maxLen)) continue;
            return null;
        }
        return r;
    }

    private void ensurePairs(List list) {
        if (1 == list.size() % 2) {
            list.remove(list.size() - 1);
        }
    }

    private URIToFileReturn uriToFile(String baseDir, ProcessorURI curi) throws AttributeNotFoundException, IOException {
        String tld;
        String dotEnd;
        String dotBegin;
        int maxPathLen;
        int maxSegLen;
        UURI uuri = curi.getUURI();
        String host = null;
        boolean hd = (Boolean)curi.get(this, HOST_DIRECTORY);
        if (hd) {
            host = uuri.getHost();
            List hostMap = (List)curi.get(this, HOST_MAP);
            if (null != hostMap && hostMap.size() > 1) {
                this.ensurePairs(hostMap);
                Iterator i = hostMap.iterator();
                boolean more = true;
                while (more && i.hasNext()) {
                    String h1 = (String)i.next();
                    String h2 = (String)i.next();
                    if (!host.equalsIgnoreCase(h1)) continue;
                    more = false;
                    if (null == h2 || 0 == h2.length()) continue;
                    host = h2;
                }
            }
        }
        int port = (Boolean)curi.get(this, PORT_DIRECTORY) != false ? uuri.getPort() : -1;
        String suffix = null;
        List ctm = (List)curi.get(this, CONTENT_TYPE_MAP);
        if (null != ctm && ctm.size() > 1) {
            this.ensurePairs(ctm);
            String contentType = curi.getContentType().toLowerCase();
            Iterator i = ctm.iterator();
            boolean more = true;
            while (more && i.hasNext()) {
                String ct = (String)i.next();
                String suf = (String)i.next();
                if (null == ct || !contentType.startsWith(ct.toLowerCase())) continue;
                more = false;
                if (null == suf || 0 == suf.length()) continue;
                suffix = suf;
            }
        }
        if ((maxSegLen = ((Integer)curi.get(this, MAX_SEG_LEN)).intValue()) < 2) {
            maxSegLen = (Integer)MAX_SEG_LEN.getDefaultValue();
        }
        if ((maxPathLen = ((Integer)curi.get(this, MAX_PATH_LENGTH)).intValue()) < 2) {
            maxPathLen = (Integer)MAX_PATH_LENGTH.getDefaultValue();
        }
        Map<String, String> characterMap = Collections.emptyMap();
        List cm = (List)curi.get(this, CHARACTER_MAP);
        if (null != cm && cm.size() > 1) {
            this.ensurePairs(cm);
            characterMap = new HashMap(cm.size());
            Iterator i = cm.iterator();
            while (i.hasNext()) {
                String s1 = (String)i.next();
                String s2 = (String)i.next();
                if (null == s1 || 1 != s1.length() || null == s2 || 0 == s2.length()) continue;
                characterMap.put(s1, s2);
            }
        }
        if (".".equals(dotBegin = (String)curi.get(this, DOT_BEGIN))) {
            dotBegin = null;
        }
        if (".".equals(dotEnd = (String)curi.get(this, DOT_END))) {
            dotEnd = null;
        }
        if (null == (tld = (String)curi.get(this, TOO_LONG_DIRECTORY)) || 0 == tld.length() || -1 != tld.indexOf(File.separatorChar)) {
            tld = (String)TOO_LONG_DIRECTORY.getDefaultValue();
        }
        HashSet<String> underscoreSet = null;
        List us = (List)curi.get(this, UNDERSCORE_SET);
        if (null != us && 0 != us.size()) {
            underscoreSet = new HashSet<String>(us.size(), 0.5f);
            for (String s : us) {
                if (null == s || 0 == s.length()) continue;
                underscoreSet.add(s.toLowerCase());
            }
        }
        return this.uriToFile(curi, host, port, uuri.getPath(), uuri.getQuery(), suffix, baseDir, maxSegLen, maxPathLen, (Boolean)curi.get(this, CASE_SENSITIVE), (String)curi.get(this, DIRECTORY_FILE), characterMap, dotBegin, dotEnd, tld, (Boolean)curi.get(this, SUFFIX_AT_END), underscoreSet);
    }

    private URIToFileReturn uriToFile(ProcessorURI curi, String host, int port, String uriPath, String query, String suffix, String baseDir, int maxSegLen, int maxPathLen, boolean caseSensitive, String dirFile, Map characterMap, String dotBegin, String dotEnd, String tooLongDir, boolean suffixAtEnd, Set underscoreSet) throws IOException {
        assert (null == host || 0 != host.length());
        assert (0 != uriPath.length());
        assert ('/' == uriPath.charAt(0)) : "uriPath: " + uriPath;
        assert (-1 == uriPath.indexOf("//")) : "uriPath: " + uriPath;
        assert (-1 == uriPath.indexOf("/./")) : "uriPath: " + uriPath;
        assert (!uriPath.endsWith("/.")) : "uriPath: " + uriPath;
        assert (null == query || -1 == query.indexOf(47)) : "query: " + query;
        assert (null == suffix || 0 != suffix.length() && -1 == suffix.indexOf(47)) : "suffix: " + suffix;
        assert (0 != baseDir.length());
        assert (maxSegLen > 2) : "maxSegLen: " + maxSegLen;
        assert (maxPathLen > 1);
        assert (maxPathLen >= maxSegLen) : "maxSegLen: " + maxSegLen + " maxPathLen: " + maxPathLen;
        assert (0 != dirFile.length());
        assert (-1 == dirFile.indexOf("/")) : "dirFile: " + dirFile;
        assert (null != characterMap);
        assert (null == dotBegin || 0 != dotBegin.length());
        assert (null == dotEnd || !dotEnd.endsWith(".")) : "dotEnd: " + dotEnd;
        assert (0 != tooLongDir.length());
        assert ('/' != tooLongDir.charAt(0)) : "tooLongDir: " + tooLongDir;
        int nSegs = 0;
        for (int i = 0; uriPath.length() != i; ++i) {
            if ('/' != uriPath.charAt(i)) continue;
            ++nSegs;
        }
        assert (nSegs > 0) : "uriPath: " + uriPath;
        PathSegment[] segs = new PathSegment[nSegs];
        int slashIndex = 0;
        for (int i = 0; segs.length - 1 != i; ++i) {
            int nsi = uriPath.indexOf(47, slashIndex + 1);
            assert (nsi > slashIndex) : "uriPath: " + uriPath;
            segs[i] = new DirSegment(uriPath, slashIndex + 1, nsi, maxSegLen, caseSensitive, curi, characterMap, dotBegin, dotEnd, underscoreSet);
            slashIndex = nsi;
        }
        segs[segs.length - 1] = slashIndex < uriPath.length() - 1 ? new EndSegment(uriPath, slashIndex + 1, uriPath.length(), maxSegLen, caseSensitive, curi, characterMap, dotBegin, query, suffix, maxPathLen, suffixAtEnd) : new EndSegment(dirFile, 0, dirFile.length(), maxSegLen, caseSensitive, curi, characterMap, null, query, suffix, maxPathLen, suffixAtEnd);
        URIToFileReturn r = this.dirPath(baseDir, host, port, segs, maxPathLen - maxSegLen);
        if (null == r) {
            PathSegment endSegment = segs[segs.length - 1];
            segs = new PathSegment[]{new DirSegment(tooLongDir, 0, tooLongDir.length(), maxSegLen, caseSensitive, curi, EMPTY_MAP, null, null, null), endSegment};
            r = this.dirPath(baseDir, host, port, segs, maxPathLen - maxSegLen);
        }
        segs[segs.length - 1].addToPath(r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPath(RecordingInputStream recis, File dest) throws IOException {
        ReplayInputStream replayis = recis.getContentReplayInputStream();
        File tf = new File(dest.getPath() + "N");
        FileOutputStream fos = new FileOutputStream(tf);
        try {
            replayis.readFullyTo((OutputStream)fos);
        }
        finally {
            fos.close();
            replayis.close();
        }
        if (!tf.renameTo(dest)) {
            throw new IOException("Can not rename " + tf.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
    }

    private static Key<String> makePatterned(String def, Pattern pattern) {
        KeyMaker km = KeyMaker.make((Object)def);
        km.addConstraint((Constraint)new PatternConstraint(pattern));
        return km.toKey();
    }

    static {
        KeyManager.addKeys(MirrorWriterProcessor.class);
    }

    class URIToFileReturn {
        private File filePath;
        private StringBuffer relativePath = new StringBuffer(255);

        URIToFileReturn(String baseDir, String host, int port) {
            StringBuffer startPath = new StringBuffer(baseDir.length() + 32);
            startPath.append(baseDir);
            if (baseDir.endsWith(File.separator)) {
                assert (1 != baseDir.length());
                startPath.deleteCharAt(startPath.length() - 1);
            }
            if (null != host) {
                startPath.append(File.separatorChar);
                startPath.append(host);
                this.relativePath.append(host);
            }
            if (port > 0) {
                startPath.append(File.separatorChar);
                startPath.append(port);
                this.relativePath.append(File.separatorChar);
                this.relativePath.append(port);
            }
            this.filePath = new File(startPath.toString());
        }

        void append(File f, String nextSegment) {
            this.filePath = f;
            if (0 != this.relativePath.length()) {
                this.relativePath.append(File.separatorChar);
            }
            this.relativePath.append(nextSegment);
        }

        File getFile() {
            return this.filePath;
        }

        String getRelativePath() {
            return this.relativePath.toString();
        }

        boolean longerThan(int maxLen) {
            return this.filePath.getPath().length() > maxLen;
        }

        void mkdirs() throws IOException {
            if (!this.filePath.exists()) {
                if (!this.filePath.mkdirs()) {
                    throw new IOException("Can not mkdir " + this.filePath.getAbsolutePath());
                }
            } else {
                if (!this.filePath.canWrite()) {
                    throw new IOException("Directory " + this.filePath.getAbsolutePath() + " not writeable.");
                }
                if (!this.filePath.isDirectory()) {
                    throw new IOException("File " + this.filePath.getAbsolutePath() + " is not a directory.");
                }
            }
        }
    }

    class LumpyString {
        private static final byte LUMP_BEGIN = 1;
        private static final byte LUMP_END = 2;
        private static final byte LUMP_MID = 4;
        private byte[] aux;
        private StringBuffer string;

        LumpyString(String str, int beginIndex, int endIndex, int padding, int maxLen, Map characterMap, String dotBegin) {
            if (beginIndex < 0) {
                throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
            }
            if (endIndex < beginIndex) {
                throw new IllegalArgumentException("endIndex < beginIndex beginIndex: " + beginIndex + "endIndex: " + endIndex);
            }
            if (padding < 0) {
                throw new IllegalArgumentException("padding < 0: " + padding);
            }
            if (maxLen < 1) {
                throw new IllegalArgumentException("maxLen < 1: " + maxLen);
            }
            if (null == characterMap) {
                throw new IllegalArgumentException("characterMap null");
            }
            if (null != dotBegin && 0 == dotBegin.length()) {
                throw new IllegalArgumentException("dotBegin empty");
            }
            int cap = Math.min(2 * (endIndex - beginIndex) + padding + 1, maxLen);
            this.string = new StringBuffer(cap);
            this.aux = new byte[cap];
            for (int i = beginIndex; i != endIndex; ++i) {
                String s = str.substring(i, i + 1);
                String lump = ".".equals(s) && i == beginIndex && null != dotBegin ? dotBegin : (String)characterMap.get(s);
                if (null == lump) {
                    if ("%".equals(s) && endIndex - i > 2 && -1 != Character.digit(str.charAt(i + 1), 16) && -1 != Character.digit(str.charAt(i + 2), 16)) {
                        lump = str.substring(i, i + 3);
                        i += 2;
                    } else {
                        lump = s;
                    }
                }
                if (this.string.length() + lump.length() > maxLen) {
                    assert (this.checkInvariants());
                    return;
                }
                this.append(lump);
            }
            assert (this.checkInvariants());
        }

        public String toString() {
            assert (this.checkInvariants());
            return this.string.toString();
        }

        void append(String lump) {
            if (null == lump) {
                throw new IllegalArgumentException("lump null");
            }
            int lumpLen = lump.length();
            if (0 == lumpLen) {
                throw new IllegalArgumentException("lump empty");
            }
            int pos = this.string.length();
            this.ensureCapacity(pos + lumpLen);
            if (1 == lumpLen) {
                this.aux[pos] = 3;
            } else {
                assert (lumpLen > 1);
                this.aux[pos] = 1;
                ++pos;
                for (int i = lumpLen - 2; 0 != i; --i) {
                    this.aux[pos] = 4;
                    ++pos;
                }
                this.aux[pos] = 2;
            }
            this.string.append(lump);
            assert (this.checkInvariants());
        }

        StringBuffer asStringBuffer() {
            return this.string;
        }

        boolean endsWith(char ch) {
            assert (this.checkInvariants());
            int len = this.string.length();
            return 0 != len && this.string.charAt(len - 1) == ch;
        }

        void prepend(char ch) {
            assert (this.checkInvariants());
            int oldLen = this.string.length();
            this.ensureCapacity(1 + oldLen);
            this.string.insert(0, ch);
            System.arraycopy(this.aux, 0, this.aux, 1, oldLen);
            this.aux[0] = 3;
            assert (this.checkInvariants());
        }

        int length() {
            assert (this.checkInvariants());
            return this.string.length();
        }

        void trimToMax(int maxLen) {
            if (maxLen < 0) {
                throw new IllegalArgumentException("maxLen < 0: " + maxLen);
            }
            assert (this.checkInvariants());
            int cl = this.string.length();
            if (cl > maxLen) {
                int nl;
                for (nl = maxLen; 0 != nl && 2 != (this.aux[nl - 1] & 2); --nl) {
                }
                for (int i = nl; i != cl; ++i) {
                    this.aux[i] = 0;
                }
                this.string.setLength(nl);
            }
            assert (this.checkInvariants());
        }

        private boolean checkInvariants() {
            assert (this.aux.length >= this.string.length()) : "aux.length: " + this.aux.length + " string.length(): " + this.string.length();
            assert (0 == this.string.length() || 1 == (this.aux[0] & 1)) : "aux[0]: " + this.aux[0];
            assert (0 == this.string.length() || 2 == (this.aux[this.string.length() - 1] & 2)) : "aux[end]: " + this.aux[this.string.length() - 1];
            return true;
        }

        private void ensureCapacity(int minCapacity) {
            assert (this.checkInvariants());
            if (minCapacity > this.aux.length) {
                int nc;
                for (nc = 2 * this.aux.length; nc < minCapacity; nc *= 2) {
                }
                byte[] oldAux = this.aux;
                this.aux = new byte[nc];
                System.arraycopy(oldAux, 0, this.aux, 0, this.string.length());
            }
            this.string.ensureCapacity(minCapacity);
            assert (this.checkInvariants());
        }
    }

    class EndSegment
    extends PathSegment {
        private int dirPathLen;
        private int maxPathLen;
        private LumpyString query;
        private String suffix;
        private boolean suffixAtEnd;
        private String uniquePart;

        EndSegment(String uriPath, int beginIndex, int endIndex, int maxSegLen, boolean caseSensitive, ProcessorURI curi, Map characterMap, String dotBegin, String query, String suffix, int maxPathLen, boolean suffixAtEnd) {
            super(maxSegLen - 1, caseSensitive, curi);
            this.query = null;
            this.suffix = null;
            this.uniquePart = null;
            int mpe = endIndex;
            int ldi = uriPath.lastIndexOf(46);
            if (ldi > 0 && ldi < endIndex - 1 && ldi > beginIndex) {
                mpe = ldi;
            }
            this.suffix = suffix;
            if (null == this.suffix && mpe < endIndex - 1) {
                LumpyString ls = new LumpyString(uriPath, mpe + 1, endIndex, 0, this.maxSegLen, characterMap, null);
                this.suffix = ls.toString();
            }
            int pad = (null == this.suffix ? 0 : 1 + this.suffix.length()) + (null == query ? 0 : query.length());
            this.mainPart = new LumpyString(uriPath, beginIndex, mpe, pad, this.maxSegLen, characterMap, dotBegin);
            this.maxPathLen = maxPathLen - 1;
            if (null != query) {
                this.query = new LumpyString(query, 0, query.length(), 0, this.maxSegLen, characterMap, null);
            }
            this.suffixAtEnd = suffixAtEnd;
        }

        void addToPath(URIToFileReturn currentPath) {
            File fsf = currentPath.getFile();
            NumberFormat nf = null;
            this.dirPathLen = 1 + fsf.getPath().length();
            int i = 0;
            while (true) {
                if (0 != i) {
                    if (null == nf) {
                        nf = NumberFormat.getIntegerInstance();
                    }
                    this.uniquePart = nf.format(i);
                }
                this.trimWithPadding(null == this.uniquePart ? 0 : this.uniquePart.length());
                String segStr = this.joinParts();
                File f = new File(fsf, segStr);
                int er = this.existsMaybeCaseSensitive(fsf, segStr, f);
                switch (er) {
                    case 1: {
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 2: {
                        if (!f.isFile()) break;
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Code: " + er);
                    }
                }
                ++i;
            }
        }

        private String joinParts() {
            StringBuffer sb = new StringBuffer(this.length());
            sb.append(this.mainPart.asStringBuffer());
            if (null != this.uniquePart) {
                sb.append(this.uniquePart);
            }
            if (this.suffixAtEnd) {
                if (null != this.query) {
                    sb.append(this.query);
                }
                if (null != this.suffix) {
                    sb.append('.');
                    sb.append(this.suffix);
                }
            } else {
                if (null != this.suffix) {
                    sb.append('.');
                    sb.append(this.suffix);
                }
                if (null != this.query) {
                    sb.append(this.query);
                }
            }
            return sb.toString();
        }

        private int lenAvail() {
            int len = this.length();
            return Math.min(this.maxSegLen - len, this.maxPathLen - this.dirPathLen - len);
        }

        private int length() {
            int r = this.mainPart.length();
            if (null != this.uniquePart) {
                r += this.uniquePart.length();
            }
            if (null != this.query) {
                r += this.query.length();
            }
            if (null != this.suffix) {
                r += 1 + this.suffix.length();
            }
            return r;
        }

        private void trimWithPadding(int padding) {
            assert (padding >= 0) : "padding: " + padding;
            int la = this.lenAvail();
            if (la >= padding) {
                return;
            }
            if (null != this.query) {
                this.query.trimToMax(Math.max(0, this.query.length() - (padding - la)));
                if (0 == this.query.length()) {
                    this.query = null;
                }
                if ((la = this.lenAvail()) >= padding) {
                    return;
                }
            }
            this.mainPart.trimToMax(Math.max(1, this.mainPart.length() - (padding - la)));
            la = this.lenAvail();
            if (la >= padding) {
                return;
            }
            if (null != this.suffix) {
                this.suffix = this.suffix.substring(0, Math.max(1, this.suffix.length() - (padding - la)));
                la = this.lenAvail();
                if (la >= padding) {
                    return;
                }
            }
            throw new IllegalStateException("Can not trim " + this.curi.toString());
        }
    }

    class DirSegment
    extends PathSegment {
        private Set underscoreSet;

        DirSegment(String uriPath, int beginIndex, int endIndex, int maxSegLen, boolean caseSensitive, ProcessorURI curi, Map characterMap, String dotBegin, String dotEnd, Set underscoreSet) {
            super(maxSegLen, caseSensitive, curi);
            this.mainPart = new LumpyString(uriPath, beginIndex, endIndex, null == dotEnd ? 0 : dotEnd.length(), this.maxSegLen, characterMap, dotBegin);
            if (null != dotEnd) {
                int dl = dotEnd.length();
                while (this.mainPart.endsWith('.')) {
                    this.mainPart.trimToMax(this.mainPart.length() - 1);
                    if (this.mainPart.length() + dl > this.maxSegLen) continue;
                    this.mainPart.append(dotEnd);
                }
            }
            this.underscoreSet = underscoreSet;
        }

        void addToPath(URIToFileReturn currentPath) throws IOException {
            NumberFormat nf = null;
            int startLen = this.mainPart.length();
            int i = 0;
            while (true) {
                if (0 != i) {
                    if (null == nf) {
                        nf = NumberFormat.getIntegerInstance();
                    }
                    String ending = nf.format(i);
                    this.mainPart.trimToMax(Math.min(startLen, this.maxSegLen - ending.length()));
                    this.mainPart.append(ending);
                }
                String segStr = this.mainPart.toString();
                if (null != this.underscoreSet && this.underscoreSet.contains(segStr.toLowerCase())) {
                    this.mainPart.prepend('_');
                    ++startLen;
                    this.mainPart.trimToMax(this.maxSegLen);
                    segStr = this.mainPart.toString();
                }
                File fsf = currentPath.getFile();
                File f = new File(fsf, segStr);
                int er = this.existsMaybeCaseSensitive(fsf, segStr, f);
                switch (er) {
                    case 1: {
                        if (!f.mkdir()) {
                            throw new IOException("Can not mkdir " + f.getAbsolutePath());
                        }
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 2: {
                        if (!f.isDirectory()) break;
                        if (!f.canWrite()) {
                            throw new IOException("Directory " + f.getAbsolutePath() + " not writeable.");
                        }
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Code: " + er);
                    }
                }
                ++i;
            }
        }
    }

    abstract class PathSegment {
        protected static final int EXISTS_NOT = 1;
        protected static final int EXISTS_EXACT_MATCH = 2;
        protected static final int EXISTS_CASE_INSENSITIVE_MATCH = 3;
        protected ProcessorURI curi;
        protected LumpyString mainPart = null;
        protected int maxSegLen;
        private boolean caseSensitive;

        PathSegment(int maxSegLen, boolean caseSensitive, ProcessorURI curi) {
            if (maxSegLen < 2) {
                throw new IllegalArgumentException("maxSegLen: " + maxSegLen);
            }
            this.maxSegLen = maxSegLen;
            this.caseSensitive = caseSensitive;
            this.curi = curi;
        }

        abstract void addToPath(URIToFileReturn var1) throws IOException;

        protected int existsMaybeCaseSensitive(File fsf, String segStr, File check) {
            if (this.caseSensitive) {
                return check.exists() ? 2 : 1;
            }
            if (!check.exists()) {
                return 1;
            }
            String[] fna = fsf.list(new CaseInsensitiveFilenameFilter(segStr));
            for (int i = 0; fna.length != i; ++i) {
                if (!segStr.equals(fna[i])) continue;
                return 2;
            }
            return 3;
        }

        class CaseInsensitiveFilenameFilter
        implements FilenameFilter {
            private String target;

            CaseInsensitiveFilenameFilter(String target) {
                if (null == target) {
                    throw new IllegalArgumentException("target null");
                }
                if (0 == target.length()) {
                    throw new IllegalArgumentException("target empty");
                }
                this.target = target;
            }

            public boolean accept(File dir, String name) {
                return this.target.equalsIgnoreCase(name);
            }
        }
    }
}

