/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.archive.io.DefaultWriterPoolSettings;
import org.archive.io.WriterPool;
import org.archive.io.WriterPoolSettings;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.recrawl.IdenticalDigestDecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.modules.writer.MetadataProvider;
import org.archive.settings.RecoverAction;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WriterPoolProcessor
extends Processor
implements Initializable,
Closeable {
    private static final Logger logger = Logger.getLogger(WriterPoolProcessor.class.getName());
    @Immutable
    public static final Key<Boolean> COMPRESS = Key.make((boolean)true);
    @Immutable
    public static final Key<String> PREFIX = Key.make((String)"IAH");
    @Immutable
    public static final Key<String> SUFFIX = Key.make((String)"${HOSTNAME}");
    @Immutable
    public static final Key<Long> MAX_SIZE_BYTES = Key.make((long)100000000L);
    @Immutable
    public static final Key<Integer> POOL_MAX_ACTIVE = Key.make((int)5);
    @Immutable
    public static final Key<Integer> POOL_MAX_WAIT = Key.make((int)300000);
    public static final Key<Boolean> SKIP_IDENTICAL_DIGESTS = Key.make((boolean)false);
    protected static final String ANNOTATION_UNWRITTEN = "unwritten";
    @Immutable
    @Expert
    public static final Key<Long> TOTAL_BYTES_TO_WRITE = Key.make((long)0L);
    @Immutable
    public static final Key<MetadataProvider> METADATA_PROVIDER = Key.makeAuto(MetadataProvider.class);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<Path> DIRECTORY = Key.make((Path)new Path("."));
    private transient WriterPool pool = null;
    private long totalBytesWritten = 0L;
    private ServerCache serverCache;
    private Path directory;
    private WriterPoolSettings settings;
    private int maxActive;
    private int maxWait;
    private AtomicInteger serial = new AtomicInteger();

    public synchronized void initialTasks(StateProvider context) {
        this.serverCache = (ServerCache)context.get((Object)this, SERVER_CACHE);
        this.directory = (Path)context.get((Object)this, DIRECTORY);
        this.maxActive = (Integer)context.get((Object)this, POOL_MAX_ACTIVE);
        this.maxWait = (Integer)context.get((Object)this, POOL_MAX_WAIT);
        this.settings = this.getWriterPoolSettings(context);
        this.setupPool(this.serial);
    }

    protected AtomicInteger getSerialNo() {
        return this.getPool().getSerialNo();
    }

    protected abstract void setupPool(AtomicInteger var1);

    protected ProcessResult checkBytesWritten(StateProvider context) {
        long max = (Long)context.get((Object)this, TOTAL_BYTES_TO_WRITE);
        if (max <= 0L) {
            return ProcessResult.PROCEED;
        }
        if (max <= this.totalBytesWritten) {
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    protected boolean shouldWrite(ProcessorURI curi) {
        boolean retVal;
        if (((Boolean)curi.get(this, SKIP_IDENTICAL_DIGESTS)).booleanValue() && IdenticalDigestDecideRule.hasIdenticalDigest(curi)) {
            curi.getAnnotations().add("unwritten:identicalDigest");
            return false;
        }
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (scheme.equals("dns")) {
            retVal = curi.getFetchStatus() == 1;
        } else if (scheme.equals("http") || scheme.equals("https")) {
            retVal = curi.getFetchStatus() > 0 && curi.getHttpMethod() != null;
        } else if (scheme.equals("ftp")) {
            retVal = curi.getFetchStatus() == 200;
        } else {
            curi.getAnnotations().add("unwritten:scheme");
            return false;
        }
        if (!retVal) {
            curi.getAnnotations().add("unwritten:status");
            return false;
        }
        return true;
    }

    protected String getHostAddress(ProcessorURI curi) {
        if (curi.getUURI().getScheme().toLowerCase().equals("dns")) {
            return (String)curi.getData().get("dns-server-ip");
        }
        CrawlHost h = ServerCacheUtil.getHostFor(this.serverCache, curi.getUURI());
        if (h == null) {
            throw new NullPointerException("Crawlhost is null for " + curi + " " + curi.getVia());
        }
        InetAddress a = h.getIP();
        if (a == null) {
            throw new NullPointerException("Address is null for " + curi + " " + curi.getVia() + ". Address " + (h.getIpFetched() == -2L ? "was never looked up." : System.currentTimeMillis() - h.getIpFetched() + " ms ago."));
        }
        return h.getIP().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(File checkpointDir, List<RecoverAction> actions) throws IOException {
        int serial = this.getSerialNo().get();
        if (this.pool.getNumActive() > 0) {
            serial = this.getSerialNo().incrementAndGet();
        }
        try {
            this.pool.close();
        }
        finally {
            this.serial = new AtomicInteger(serial);
            this.setupPool(this.serial);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setupPool(this.serial);
    }

    protected WriterPool getPool() {
        return this.pool;
    }

    protected void setPool(WriterPool pool) {
        this.pool = pool;
    }

    protected long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    protected void setTotalBytesWritten(long totalBytesWritten) {
        this.totalBytesWritten = totalBytesWritten;
    }

    protected abstract List<String> getMetadata(StateProvider var1);

    protected abstract Key<List<String>> getPathKey();

    private List<File> getOutputDirs(StateProvider context) {
        List list = (List)context.get((Object)this, this.getPathKey());
        ArrayList<File> results = new ArrayList<File>();
        for (String path : list) {
            File f = new File(this.directory.toFile(), path);
            if (!f.exists()) {
                try {
                    f.mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            results.add(f);
        }
        return results;
    }

    protected WriterPoolSettings getWriterPoolSettings() {
        return this.settings;
    }

    protected int getMaxActive() {
        return this.maxActive;
    }

    protected int getMaxWait() {
        return this.maxWait;
    }

    private WriterPoolSettings getWriterPoolSettings(StateProvider context) {
        DefaultWriterPoolSettings result = new DefaultWriterPoolSettings();
        result.setMaxSize(((Long)context.get((Object)this, MAX_SIZE_BYTES)).longValue());
        result.setMetadata(this.getMetadata(context));
        result.setOutputDirs(this.getOutputDirs(context));
        result.setPrefix((String)context.get((Object)this, PREFIX));
        String sfx = (String)context.get((Object)this, SUFFIX);
        sfx = sfx.trim();
        if (sfx.contains("${HOSTNAME}")) {
            String str = "localhost.localdomain";
            try {
                str = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ue) {
                logger.severe("Failed getHostAddress for this host: " + ue);
            }
            sfx = sfx.replace("${HOSTNAME}", str);
        }
        result.setSuffix(sfx);
        result.setCompressed(((Boolean)context.get((Object)this, COMPRESS)).booleanValue());
        return result;
    }

    @Override
    protected void innerProcess(ProcessorURI puri) {
        throw new AssertionError();
    }

    @Override
    protected abstract ProcessResult innerProcessResult(ProcessorURI var1);

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    protected boolean shouldProcess(ProcessorURI uri) {
        if (!(uri instanceof ProcessorURI)) {
            return false;
        }
        ProcessorURI curi = uri;
        if (curi.getFetchStatus() <= 0) {
            return false;
        }
        long recordLength = curi.getContentSize();
        return recordLength > 0L;
    }

    static {
        KeyManager.addKeys(WriterPoolProcessor.class);
    }
}

