/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.automaton;

import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.urlfilter.api.RegexRule;
import org.apache.nutch.urlfilter.api.RegexURLFilterBase;

public class AutomatonURLFilter
extends RegexURLFilterBase {
    public static final String URLFILTER_AUTOMATON_FILE = "urlfilter.automaton.file";
    public static final String URLFILTER_AUTOMATON_RULES = "urlfilter.automaton.rules";

    public AutomatonURLFilter() {
    }

    public AutomatonURLFilter(String filename) throws IOException, PatternSyntaxException {
        super(filename);
    }

    AutomatonURLFilter(Reader reader) throws IOException, IllegalArgumentException {
        super(reader);
    }

    protected Reader getRulesReader(Configuration conf) throws IOException {
        String stringRules = conf.get(URLFILTER_AUTOMATON_RULES);
        if (stringRules != null) {
            return new StringReader(stringRules);
        }
        String fileRules = conf.get(URLFILTER_AUTOMATON_FILE);
        return conf.getConfResourceAsReader(fileRules);
    }

    protected RegexRule createRule(boolean sign, String regex) {
        return new Rule(sign, regex);
    }

    public static void main(String[] args) throws IOException {
        AutomatonURLFilter.main((RegexURLFilterBase)new AutomatonURLFilter(), (String[])args);
    }

    private class Rule
    extends RegexRule {
        private RunAutomaton automaton;

        Rule(boolean sign, String regex) {
            super(sign, regex);
            this.automaton = new RunAutomaton(new RegExp(regex, 65535).toAutomaton());
        }

        protected boolean match(String url) {
            return this.automaton.run(url);
        }
    }
}

