/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class FairGenericObjectPool
extends GenericObjectPool {
    protected List _borrowerQueue = Collections.synchronizedList(new LinkedList());

    public FairGenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, GenericObjectPool.Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, false, false, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, -1L);
    }

    public FairGenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis) {
        super(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, softMinEvictableIdleTimeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object borrowObject() throws Exception {
        this.assertOpen();
        starttime = System.currentTimeMillis();
        var3_2 = this;
        synchronized (var3_2) {
            this._borrowerQueue.add(Thread.currentThread());
lbl8:
            // 2 sources

            block23: while (true) {
                block29: {
                    pair = null;
                    v0 = eligible = this._borrowerQueue.get(0) == Thread.currentThread();
                    if (eligible) {
                        try {
                            pair = (GenericKeyedObjectPool.ObjectTimestampPair)this._pool.removeFirst();
                        }
                        catch (NoSuchElementException e) {
                            // empty catch block
                        }
                    }
                    if (null != pair || eligible && (this._maxActive < 0 || this._numActive < this._maxActive)) break block29;
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException("Pool exhausted");
                        }
                        case 1: {
                            try {
                                if (this._maxWait > 0L) ** GOTO lbl28
                                this.wait();
                                ** GOTO lbl35
lbl28:
                                // 1 sources

                                elapsed = System.currentTimeMillis() - starttime;
                                waitTime = this._maxWait - elapsed;
                                if (waitTime > 0L) {
                                    this.wait(waitTime);
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
lbl35:
                            // 3 sources

                            if (this._maxWait <= 0L || System.currentTimeMillis() - starttime < this._maxWait) continue block23;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        default: {
                            throw new IllegalArgumentException("WhenExhaustedAction property " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
                ++this._numActive;
                newlyCreated = false;
                if (null == pair) {
                    try {
                        obj = this._factory.makeObject();
                        pair = new GenericKeyedObjectPool.ObjectTimestampPair(obj);
                        newlyCreated = true;
                        waitTime = pair.value;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 23, 10, 28] lbl48 : MonitorExitStatement: MONITOREXIT : var3_2
                        this._borrowerQueue.remove(Thread.currentThread());
                        return waitTime;
                    }
                    finally {
                        if (!newlyCreated) {
                            --this._numActive;
                            this.notifyAll();
                        }
                    }
                }
                ** GOTO lbl-1000
                break;
            }
        }
        {
            catch (Throwable var12_16) {
                this._borrowerQueue.remove(Thread.currentThread());
                throw var12_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this._factory.activateObject(pair.value);
                    if (this._testOnBorrow && !this._factory.validateObject(pair.value)) {
                        throw new Exception("ValidateObject failed");
                    }
                    obj = pair.value;
                    // MONITOREXIT @DISABLED, blocks:[19, 6, 10] lbl66 : MonitorExitStatement: MONITOREXIT : var3_2
                    this._borrowerQueue.remove(Thread.currentThread());
                }
                catch (Throwable e) {}
                {
                    --this._numActive;
                    this.notifyAll();
                    try {
                        this._factory.destroyObject(pair.value);
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                    if (newlyCreated) throw new NoSuchElementException("Could not create a validated object, cause: " + e.getMessage());
                    ** continue;
                }
                return obj;
            }
        }
    }
}

