/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.FairGenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class FairGenericObjectPoolTest
extends TestCase {
    public void testFair() throws InterruptedException {
        FairGenericObjectPool pool = new FairGenericObjectPool();
        Object[] borrowOrder = this.tryPool(pool);
        Object[] sortedOrder = (Object[])borrowOrder.clone();
        Arrays.sort(sortedOrder);
        FairGenericObjectPoolTest.assertTrue((String)"unexpectedly unfair", (boolean)Arrays.equals(borrowOrder, sortedOrder));
    }

    private Object[] tryPool(GenericObjectPool pool) throws InterruptedException {
        BlockerObjectFactory factory = new BlockerObjectFactory();
        pool.setFactory((PoolableObjectFactory)factory);
        pool.setMaxActive(1);
        List borrowOrder = Collections.synchronizedList(new LinkedList());
        int i = 0;
        while (i < 10) {
            Contender c = new Contender(borrowOrder);
            c.pool = pool;
            c.ordinal = i++;
            new Thread(c).start();
            Thread.sleep(500L);
        }
        factory.single.release();
        Thread.sleep(5000L);
        return borrowOrder.toArray();
    }

    class Blocker {
        boolean block = true;

        Blocker() {
        }

        public synchronized void acquire() {
            if (this.block) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.block = false;
        }

        public synchronized void release() {
            this.notifyAll();
        }
    }

    class BlockerObjectFactory
    extends BasePoolableObjectFactory {
        public Blocker single;

        BlockerObjectFactory() {
            this.single = new Blocker();
        }

        public Object makeObject() throws Exception {
            System.out.println("makeObject");
            return this.single;
        }
    }

    class Contender
    implements Runnable {
        public GenericObjectPool pool;
        public int ordinal;
        public List reportList;

        public Contender(List borrowOrder) {
            this.reportList = borrowOrder;
        }

        public void run() {
            try {
                Blocker block = (Blocker)this.pool.borrowObject();
                System.out.println("borrowed #" + this.ordinal);
                this.reportList.add(new Integer(this.ordinal));
                block.acquire();
                System.out.println("returning #" + this.ordinal);
                this.pool.returnObject(block);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

