/*
 * Decompiled with CFR 0.152.
 */
package org.archive.httpclient;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConfigurableX509TrustManager
implements X509TrustManager {
    protected static Logger logger = Logger.getLogger("org.archive.httpclient.ConfigurableX509TrustManager");
    public static final String OPEN = "open";
    public static final String LOOSE = "loose";
    public static final String NORMAL = "normal";
    public static final String STRICT = "strict";
    public static String[] LEVELS_AS_ARRAY = new String[]{"open", "loose", "normal", "strict"};
    private static List LEVELS = Arrays.asList(LEVELS_AS_ARRAY);
    public static final String DEFAULT = "open";
    private String trustLevel = "open";
    private X509TrustManager standardTrustManager = null;

    public ConfigurableX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        this("open");
    }

    public ConfigurableX509TrustManager(String level) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException(TrustManagerFactory.getDefaultAlgorithm() + " trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        this.trustLevel = LEVELS.contains(level.toLowerCase()) ? level : "open";
    }

    public void checkClientTrusted(X509Certificate[] certificates, String type) throws CertificateException {
        if (this.trustLevel.equals("open")) {
            return;
        }
        this.standardTrustManager.checkClientTrusted(certificates, type);
    }

    public void checkServerTrusted(X509Certificate[] certificates, String type) throws CertificateException {
        if (this.trustLevel.equals("open")) {
            return;
        }
        try {
            this.standardTrustManager.checkServerTrusted(certificates, type);
            if (this.trustLevel.equals(STRICT)) {
                logger.severe("strict not implemented.");
            }
        }
        catch (CertificateException e) {
            if (this.trustLevel.equals(LOOSE) && certificates != null && certificates.length == 1) {
                X509Certificate certificate = certificates[0];
                certificate.checkValidity();
            }
            throw e;
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

