/*
 * Decompiled with CFR 0.152.
 */
package org.archive.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpParams;

public class SingleHttpConnectionManager
extends SimpleHttpConnectionManager {
    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
        HttpConnection conn = new HttpConnection(hostConfiguration);
        conn.setHttpConnectionManager((HttpConnectionManager)this);
        conn.getParams().setDefaults((HttpParams)this.getParams());
        return conn;
    }

    public void releaseConnection(HttpConnection conn) {
        conn.close();
        SingleHttpConnectionManager.finishLast(conn);
    }

    static void finishLast(HttpConnection conn) {
        InputStream lastResponse = conn.getLastResponseInputStream();
        if (lastResponse != null) {
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
            }
            catch (IOException ioe) {
                conn.close();
            }
        }
    }
}

