/*
 * Decompiled with CFR 0.152.
 */
package org.archive.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleCache {
    private static final Logger LOGGER = Logger.getLogger(LocaleCache.class.getName());
    private static final Map<ClassLocale, Map<String, String>> properties = new ConcurrentHashMap<ClassLocale, Map<String, String>>();

    private LocaleCache() {
    }

    public static Map<String, String> load(Class c, Locale locale) {
        ClassLocale cl = new ClassLocale(c, locale);
        Map<String, String> result = properties.get(cl);
        if (result != null) {
            return result;
        }
        result = LocaleCache.localizedInfo(c, locale);
        properties.put(cl, result);
        return result;
    }

    private static String getBaseName(Class c) {
        String name = c.getName();
        int p = name.lastIndexOf(46);
        return p >= 0 ? name.substring(p + 1) : name;
    }

    private static boolean exists(String s) {
        if (s == null) {
            return false;
        }
        return s.length() > 0;
    }

    private static void addWhatExists(List<String> list, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean languageExists = LocaleCache.exists(language);
        boolean countryExists = LocaleCache.exists(country);
        boolean variantExists = LocaleCache.exists(variant);
        if (languageExists && countryExists && variantExists) {
            list.add(language + "_" + country + "_" + variant);
        }
        if (languageExists && countryExists) {
            list.add(language + "_" + country);
        }
        if (languageExists) {
            list.add(language);
        }
    }

    private static Map<String, String> localizedInfo(Class c, Locale locale) {
        String base = LocaleCache.getBaseName(c);
        ArrayList<String> attempts = new ArrayList<String>(6);
        LocaleCache.addWhatExists(attempts, locale);
        LocaleCache.addWhatExists(attempts, Locale.getDefault());
        Map<String, String> result = null;
        for (String s : attempts) {
            String resource = LocaleCache.getBaseName(c) + "_" + s + ".utf8";
            result = LocaleCache.attempt(c, resource);
            if (result == null) continue;
            return result;
        }
        LOGGER.severe("No info for " + base + " in " + locale + ".");
        Map empty = Collections.EMPTY_MAP;
        return empty;
    }

    private static Map<String, String> attempt(Class c, String resource) {
        InputStream inp = c.getResourceAsStream(resource);
        if (inp == null) {
            return null;
        }
        try {
            InputStreamReader r = new InputStreamReader(inp, "UTF-8");
            BufferedReader br = new BufferedReader(r);
            Map<String, String> map = LocaleCache.read(br);
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inp.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Couldn't close resource.", e);
            }
        }
    }

    private static Map<String, String> read(BufferedReader br) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String s = LocaleCache.skipBlank(br);
        while (s != null) {
            if (s.endsWith(":")) {
                s = s.substring(0, s.length() - 1);
            }
            String value = LocaleCache.readUntilBlank(br);
            result.put(s, value);
            s = LocaleCache.skipBlank(br);
        }
        return result;
    }

    private static String skipBlank(BufferedReader br) throws IOException {
        String s = br.readLine();
        while (s != null) {
            if (!LocaleCache.isBlankLine(s)) {
                return s;
            }
            s = br.readLine();
        }
        return null;
    }

    private static String readUntilBlank(BufferedReader br) throws IOException {
        StringBuilder sb = new StringBuilder();
        String s = br.readLine();
        while (s != null) {
            if (LocaleCache.isBlankLine(s)) {
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            sb.append(s).append(' ');
            s = br.readLine();
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static boolean isBlankLine(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).startsWith("#")) {
            return true;
        }
        return s.length() == 0;
    }

    private static class ClassLocale {
        public Class c;
        public Locale locale;

        public ClassLocale(Class c, Locale locale) {
            this.c = c;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassLocale)) {
                return false;
            }
            ClassLocale cl = (ClassLocale)o;
            return cl.c.equals(this.c) && cl.locale.equals(this.locale);
        }

        public int hashCode() {
            return this.c.hashCode() ^ this.locale.hashCode();
        }
    }
}

