/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.archive.io.ArchiveRecord;
import org.archive.io.Warc2Arc;
import org.archive.io.WriterPoolMember;
import org.archive.io.arc.ARCReader;
import org.archive.io.arc.ARCReaderFactory;
import org.archive.io.arc.ARCRecord;
import org.archive.io.warc.WARCWriter;
import org.archive.util.FileUtils;
import org.archive.util.anvl.ANVLRecord;

public class Arc2Warc {
    private static void usage(HelpFormatter formatter, Options options, int exitCode) {
        formatter.printHelp("java org.archive.io.arc.Arc2Warc [--force] ARC_INPUT WARC_OUTPUT", options);
        System.exit(exitCode);
    }

    private static String getRevision() {
        return Warc2Arc.parseRevision("$Revision: 5802 $");
    }

    public void transform(File arc, File warc, boolean force) throws IOException {
        FileUtils.isReadable(arc);
        if (warc.exists() && !force) {
            throw new IOException("Target WARC already exists. Will not overwrite.");
        }
        ARCReader reader = ARCReaderFactory.get(arc, false, 0L);
        this.transform(reader, warc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(ARCReader reader, File warc) throws IOException {
        Object writer = null;
        reader.setDigest(false);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(warc));
            Iterator<ArchiveRecord> i = reader.iterator();
            ARCRecord firstRecord = (ARCRecord)i.next();
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)firstRecord.getHeader().getLength());
            firstRecord.dump(baos);
            ANVLRecord ar = new ANVLRecord(1);
            ar.addLabelValue("Filedesc", baos.toString());
            ArrayList<String> metadata = new ArrayList<String>(1);
            metadata.add(ar.toString());
            writer = new WARCWriter(null, bos, warc, reader.isCompressed(), null, metadata);
            ((WARCWriter)writer).writeWarcinfoRecord(warc.getName(), "Made from " + reader.getReaderIdentifier() + " by " + this.getClass().getName() + "/" + Arc2Warc.getRevision());
            while (i.hasNext()) {
                this.write((WARCWriter)writer, (ARCRecord)i.next());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                Logger l = Logger.getLogger(writer.getClass().getName());
                Level oldLevel = l.getLevel();
                l.setLevel(Level.WARNING);
                try {
                    ((WriterPoolMember)writer).close();
                }
                finally {
                    l.setLevel(oldLevel);
                }
            }
        }
    }

    protected void write(WARCWriter writer, ARCRecord r) throws IOException {
        ANVLRecord ar = new ANVLRecord();
        String ip = (String)r.getHeader().getHeaderValue("ip-address");
        if (ip != null && ip.length() > 0) {
            ar.addLabelValue("IP-Address", ip);
        }
        writer.writeResourceRecord(r.getHeader().getUrl(), r.getHeader().getDate(), r.getHeader().getContentBegin() > 0 ? "application/http; msgtype=response" : r.getHeader().getMimetype(), ar, r, r.getHeader().getLength());
    }

    public static void main(String[] args) throws ParseException, IOException, java.text.ParseException {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Prints this message and exits."));
        options.addOption(new Option("f", "force", false, "Force overwrite of target file."));
        PosixParser parser = new PosixParser();
        CommandLine cmdline = parser.parse(options, args, false);
        List cmdlineArgs = cmdline.getArgList();
        Option[] cmdlineOptions = cmdline.getOptions();
        HelpFormatter formatter = new HelpFormatter();
        if (cmdlineArgs.size() <= 0) {
            Arc2Warc.usage(formatter, options, 0);
        }
        boolean force = false;
        block4: for (int i = 0; i < cmdlineOptions.length; ++i) {
            switch (cmdlineOptions[i].getId()) {
                case 104: {
                    Arc2Warc.usage(formatter, options, 0);
                    continue block4;
                }
                case 102: {
                    force = true;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected option: " + cmdlineOptions[i].getId());
                }
            }
        }
        if (cmdlineArgs.size() != 2) {
            Arc2Warc.usage(formatter, options, 0);
        }
        new Arc2Warc().transform(new File(cmdlineArgs.get(0).toString()), new File(cmdlineArgs.get(1).toString()), force);
    }
}

