/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.archive.io.ArchiveFileConstants;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.RandomAccessInputStream;
import org.archive.io.RecoverableIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveReader
implements ArchiveFileConstants,
Iterable<ArchiveRecord> {
    private boolean compressed = false;
    private boolean digest = true;
    private boolean strict = false;
    private InputStream in = null;
    public static final int MAX_ALLOWED_RECOVERABLES = 10;
    private ArchiveRecord currentRecord = null;
    private String identifier = null;
    private String version = null;

    protected ArchiveReader() {
    }

    protected void initialize(String i) {
        this.setReaderIdentifier(i);
    }

    protected InputStream getInputStream(File f, long offset) throws IOException {
        return new RandomAccessBufferedInputStream(new RandomAccessInputStream(f, offset));
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public ArchiveRecord get(long offset) throws IOException {
        this.cleanupCurrentRecord();
        RepositionableStream ps = (RepositionableStream)this.in;
        long currentOffset = ps.position();
        if (currentOffset != offset) {
            currentOffset = offset;
            ps.position(offset);
        }
        return this.createArchiveRecord(this.in, currentOffset);
    }

    public ArchiveRecord get() throws IOException {
        return this.createArchiveRecord(this.in, ((RepositionableStream)this.in).position());
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    protected void rewind() throws IOException {
        this.cleanupCurrentRecord();
        if (this.in instanceof RepositionableStream) {
            try {
                ((RepositionableStream)this.in).position(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IOException("Stream is not resettable.");
        }
    }

    protected void cleanupCurrentRecord() throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
            this.gotoEOR(this.currentRecord);
            this.currentRecord = null;
        }
    }

    protected abstract ArchiveRecord createArchiveRecord(InputStream var1, long var2) throws IOException;

    protected abstract void gotoEOR(ArchiveRecord var1) throws IOException;

    public abstract String getFileExtension();

    public abstract String getDotFileExtension();

    public String getVersion() {
        return this.version;
    }

    public List<ArchiveRecordHeader> validate() throws IOException {
        return this.validate(-1);
    }

    public List<ArchiveRecordHeader> validate(int noRecords) throws IOException {
        ArrayList<ArchiveRecordHeader> hs = new ArrayList<ArchiveRecordHeader>();
        int count = 0;
        this.setStrict(true);
        Iterator<ArchiveRecord> i = this.iterator();
        while (i.hasNext()) {
            ++count;
            ArchiveRecord r = i.next();
            if (r.getHeader().getLength() <= 0L && r.getHeader().getMimetype().equals("no-type")) {
                throw new IOException("ARCRecord content is empty.");
            }
            r.close();
            hs.add(r.getHeader());
        }
        if (noRecords != -1 && count != noRecords) {
            throw new IOException("Count of records, " + Integer.toString(count) + " is less than expected " + Integer.toString(noRecords));
        }
        return hs;
    }

    public boolean isValid() {
        boolean valid = false;
        try {
            this.validate();
            valid = true;
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean s) {
        this.strict = s;
    }

    public void setDigest(boolean d) {
        this.digest = d;
    }

    public boolean isDigest() {
        return this.digest;
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    @Override
    public Iterator<ArchiveRecord> iterator() {
        try {
            this.cleanupCurrentRecord();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.rewind();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ArchiveRecordIterator();
    }

    protected void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    protected ArchiveRecord getCurrentRecord() {
        return this.currentRecord;
    }

    protected ArchiveRecord currentRecord(ArchiveRecord currentRecord) {
        this.currentRecord = currentRecord;
        return currentRecord;
    }

    protected InputStream getIn() {
        return this.in;
    }

    protected void setIn(InputStream in) {
        this.in = in;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public String getReaderIdentifier() {
        return this.identifier;
    }

    protected void setReaderIdentifier(String i) {
        this.identifier = i;
    }

    public void logStdErr(Level level, String message) {
        System.err.println(level.toString() + " " + message);
    }

    protected static String stripExtension(String name, String ext) {
        return !name.endsWith(ext) ? name : name.substring(0, name.length() - ext.length());
    }

    public String getFileName() {
        return new File(this.getReaderIdentifier()).getName();
    }

    public String getStrippedFileName() {
        return ArchiveReader.getStrippedFileName(this.getFileName(), this.getDotFileExtension());
    }

    public static String getStrippedFileName(String name, String dotFileExtension) {
        name = ArchiveReader.stripExtension(name, ".gz");
        return ArchiveReader.stripExtension(name, dotFileExtension);
    }

    protected static boolean getTrueOrFalse(String value) {
        if (value == null || value.length() <= 0) {
            return false;
        }
        return Boolean.TRUE.toString().equals(value.toLowerCase());
    }

    protected boolean output(String format) throws IOException, ParseException {
        boolean result = true;
        if (format.equals("dump")) {
            this.setDigest(false);
            this.dump(false);
        } else if (format.equals("gzipdump")) {
            this.setDigest(false);
            this.dump(true);
        } else if (format.equals("cdx")) {
            this.cdxOutput(false);
        } else if (format.equals("cdxfile")) {
            this.cdxOutput(true);
        } else {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cdxOutput(boolean toFile) throws IOException {
        Writer cdxWriter = null;
        if (toFile) {
            String cdxFilename = ArchiveReader.stripExtension(this.getReaderIdentifier(), ".gz");
            cdxFilename = ArchiveReader.stripExtension(cdxFilename, this.getDotFileExtension());
            cdxFilename = cdxFilename + ".cdx";
            cdxWriter = new BufferedWriter(new FileWriter(cdxFilename));
        }
        String header = "CDX b e a m s c " + (this.isCompressed() ? "V" : "v") + " n g";
        if (toFile) {
            cdxWriter.write(header);
            ((BufferedWriter)cdxWriter).newLine();
        } else {
            System.out.println(header);
        }
        String strippedFileName = this.getStrippedFileName();
        try {
            for (ArchiveRecord r : this) {
                if (toFile) {
                    cdxWriter.write(r.outputCdx(strippedFileName));
                    ((BufferedWriter)cdxWriter).newLine();
                    continue;
                }
                System.out.println(r.outputCdx(strippedFileName));
            }
        }
        finally {
            if (toFile) {
                ((BufferedWriter)cdxWriter).close();
            }
        }
    }

    public boolean outputRecord(String format) throws IOException {
        boolean result = true;
        if (format.equals("cdx")) {
            System.out.println(this.get().outputCdx(this.getStrippedFileName()));
        } else if (format.equals("dump")) {
            this.setDigest(false);
            this.get().dump();
        } else {
            result = false;
        }
        return result;
    }

    public abstract void dump(boolean var1) throws IOException, ParseException;

    public abstract ArchiveReader getDeleteFileOnCloseReader(File var1);

    protected static void outputRecord(ArchiveReader r, String format) throws IOException {
        if (!r.outputRecord(format)) {
            throw new IOException("Unsupported format (or unsupported on a single record): " + format);
        }
    }

    protected static Options getOptions() {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Prints this message and exits."));
        options.addOption(new Option("o", "offset", true, "Outputs record at this offset into file."));
        options.addOption(new Option("d", "digest", true, "Pass true|false. Expensive. Default: true (SHA-1)."));
        options.addOption(new Option("s", "strict", false, "Strict mode. Fails parse if incorrectly formatted file."));
        options.addOption(new Option("f", "format", true, "Output options: 'cdx', cdxfile', 'dump', 'gzipdump','or 'nohead'. Default: 'cdx'."));
        return options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArchiveRecordIterator
    implements Iterator<ArchiveRecord> {
        private final Logger logger = Logger.getLogger(this.getClass().getName());

        protected ArchiveRecordIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                ArchiveReader.this.cleanupCurrentRecord();
            }
            catch (IOException e) {
                if (ArchiveReader.this.isStrict()) {
                    throw new RuntimeException(e);
                }
                if (e instanceof EOFException) {
                    this.logger.warning("Premature EOF cleaning up " + ((Object)ArchiveReader.this.currentRecord.getHeader()).toString() + ": " + e.getMessage());
                    return false;
                }
                this.logger.warning("Trying skip of failed record cleanup of " + ((Object)ArchiveReader.this.currentRecord.getHeader()).toString() + ": " + e.getMessage());
            }
            return this.innerHasNext();
        }

        protected boolean innerHasNext() {
            long offset = -1L;
            try {
                offset = ((RepositionableStream)ArchiveReader.this.getInputStream()).position();
                return ArchiveReader.this.getInputStream().available() > 0;
            }
            catch (IOException e) {
                throw new RuntimeException("Offset " + offset, e);
            }
        }

        @Override
        public ArchiveRecord next() {
            long offset = -1L;
            try {
                offset = ((RepositionableStream)ArchiveReader.this.getInputStream()).position();
                return this.exceptionNext();
            }
            catch (IOException e) {
                if (!ArchiveReader.this.isStrict()) {
                    try {
                        if (this.hasNext()) {
                            ArchiveReader.this.getLogger().warning("Bad Record. Trying skip (Current offset " + offset + "): " + e.getMessage());
                            return this.exceptionNext();
                        }
                        throw new RuntimeException("Retried but no next record (Offset " + offset + ")", e);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException("After retry (Offset " + offset + ")", e1);
                    }
                }
                throw new RuntimeException("(Offset " + offset + ")", e);
            }
        }

        protected ArchiveRecord exceptionNext() throws IOException, RuntimeException {
            ArchiveRecord result = null;
            RecoverableIOException ioe = null;
            for (int i = 10; i > 0 && result == null; --i) {
                ioe = null;
                try {
                    result = this.innerNext();
                }
                catch (RecoverableIOException e) {
                    ioe = e;
                    ArchiveReader.this.getLogger().warning(e.getMessage());
                    if (!this.hasNext()) break;
                }
            }
            if (ioe != null) {
                throw new RuntimeException("Retried 10 times in a row", ioe);
            }
            return result;
        }

        protected ArchiveRecord innerNext() throws IOException {
            return ArchiveReader.this.get(((RepositionableStream)ArchiveReader.this.getInputStream()).position());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class RandomAccessBufferedInputStream
    extends BufferedInputStream
    implements RepositionableStream {
        public RandomAccessBufferedInputStream(RandomAccessInputStream is) throws IOException {
            super(is);
        }

        public RandomAccessBufferedInputStream(RandomAccessInputStream is, int size) throws IOException {
            super(is, size);
        }

        public long position() throws IOException {
            return ((RandomAccessInputStream)this.in).position() - (long)(this.count - this.pos);
        }

        public void position(long position) throws IOException {
            this.pos = 0;
            this.count = 0;
            ((RandomAccessInputStream)this.in).position(position);
        }

        public int available() throws IOException {
            long amount = (long)this.in.available() + (long)(this.count - this.pos);
            return amount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        }
    }
}

