/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import org.archive.io.SeekInputStream;

public class ArraySeekInputStream
extends SeekInputStream {
    private byte[] array;
    private int offset;

    public ArraySeekInputStream(byte[] array) {
        this.array = array;
        this.offset = 0;
    }

    public int read() {
        if (this.offset >= this.array.length) {
            return -1;
        }
        int r = this.array[this.offset] & 0xFF;
        ++this.offset;
        return r;
    }

    public int read(byte[] buf, int ofs, int len) {
        if (this.offset >= this.array.length) {
            return 0;
        }
        len = Math.min(len, this.array.length - this.offset);
        System.arraycopy(this.array, this.offset, buf, ofs, len);
        this.offset += len;
        return len;
    }

    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public long position() {
        return this.offset;
    }

    public void position(long p) throws IOException {
        if (p < 0L || p > (long)this.array.length) {
            throw new IOException("Invalid position: " + p);
        }
        this.offset = (int)p;
    }
}

