/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.archive.settings.RecoverAction;
import org.archive.util.ArchiveUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlerJournal {
    public static final String LOG_ERROR = "E ";
    public static final String LOG_TIMESTAMP = "T ";
    protected Writer out = null;
    protected long lines = 0L;
    protected int timestamp_interval = 0;
    public static final String GZIP_SUFFIX = ".gz";
    protected File gzipFile = null;
    protected MutableString accumulatingBuffer = new MutableString(1024);

    public static BufferedReader getBufferedReader(File source) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(source));
        boolean isGzipped = source.getName().toLowerCase().endsWith(GZIP_SUFFIX);
        if (isGzipped) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public CrawlerJournal(String path, String filename) throws IOException {
        this.gzipFile = new File(path, filename);
        this.out = this.initialize(this.gzipFile);
    }

    public CrawlerJournal(File file) throws IOException {
        this.gzipFile = file;
        this.out = this.initialize(this.gzipFile);
    }

    protected Writer initialize(File f) throws FileNotFoundException, IOException {
        return new OutputStreamWriter(new GZIPOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(f))));
    }

    public synchronized void writeLine(String string) {
        try {
            this.out.write(string);
            this.out.write("\n");
            this.noteLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void writeLine(String s1, String s2) {
        try {
            this.out.write(s1);
            this.out.write(s2);
            this.out.write("\n");
            this.noteLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void writeLine(String s1, String s2, String s3) {
        try {
            this.out.write(s1);
            this.out.write(s2);
            this.out.write(s3);
            this.out.write("\n");
            this.noteLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void writeLine(MutableString mstring) {
        if (this.out == null) {
            return;
        }
        try {
            mstring.write(this.out);
            this.out.write("\n");
            this.noteLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void noteLine() throws IOException {
        ++this.lines;
        this.considerTimestamp();
    }

    protected void considerTimestamp() throws IOException {
        if (this.timestamp_interval > 0 && this.lines % (long)this.timestamp_interval == 0L) {
            this.out.write(LOG_TIMESTAMP);
            this.out.write(ArchiveUtils.getLog14Date());
            this.out.write("\n");
        }
    }

    public void close() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void seriousError(String err) {
        this.writeLine(LOG_ERROR + ArchiveUtils.getLog14Date() + " " + err + "\n");
    }

    public synchronized void checkpoint(File checkpointDir, List<RecoverAction> actions) throws IOException {
        if (this.out == null || !this.gzipFile.exists()) {
            return;
        }
        this.close();
        this.gzipFile.renameTo(new File(this.gzipFile.getParentFile(), this.gzipFile.getName() + "." + checkpointDir.getName()));
        this.out = this.initialize(this.gzipFile);
    }
}

