/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.archive.io.WriterPoolSettings;
import org.archive.settings.CheckpointRecovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWriterPoolSettings
implements WriterPoolSettings,
Serializable {
    private static final long serialVersionUID = 1L;
    private long maxSize;
    private List metadata = new ArrayList();
    private transient List<File> outputDirs = new ArrayList<File>();
    private String prefix;
    private String suffix;
    private boolean compressed;

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public List getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List metadata) {
        this.metadata = metadata;
    }

    @Override
    public List<File> getOutputDirs() {
        return this.outputDirs;
    }

    public void setOutputDirs(List<File> outputDirs) {
        this.outputDirs = outputDirs;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.outputDirs.size());
        for (File f : this.outputDirs) {
            out.writeUTF(f.getAbsolutePath());
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        CheckpointRecovery cr = null;
        this.outputDirs = new ArrayList<File>();
        if (input instanceof CheckpointRecovery) {
            cr = (CheckpointRecovery)((Object)input);
        }
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            String path = input.readUTF();
            if (cr != null) {
                path = cr.translatePath(path);
            }
            File f = new File(path);
            f.mkdirs();
            this.outputDirs.add(f);
        }
    }
}

