/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationFileHandler
extends FileHandler {
    private LinkedList<String> filenameSeries = new LinkedList();
    private boolean shouldManifest = false;

    public List getFilenameSeries() {
        return this.filenameSeries;
    }

    public GenerationFileHandler(String pattern, boolean append, boolean shouldManifest) throws IOException, SecurityException {
        super(pattern, append);
        this.filenameSeries.addFirst(pattern);
        this.shouldManifest = shouldManifest;
    }

    public GenerationFileHandler(LinkedList<String> filenameSeries, boolean shouldManifest) throws IOException {
        super(filenameSeries.getFirst(), false);
        this.filenameSeries = filenameSeries;
        this.shouldManifest = shouldManifest;
    }

    public GenerationFileHandler rotate(String storeSuffix, String activeSuffix) throws IOException {
        this.close();
        String filename = this.filenameSeries.getFirst();
        if (!filename.endsWith(activeSuffix)) {
            throw new FileNotFoundException("Active file does not have expected suffix");
        }
        File activeFile = new File(filename);
        String storeFilename = filename.substring(0, filename.length() - activeSuffix.length()) + storeSuffix;
        File storeFile = new File(storeFilename);
        if (!activeFile.renameTo(storeFile)) {
            throw new IOException("Unable to move " + filename + " to " + storeFilename);
        }
        this.filenameSeries.add(1, storeFilename);
        GenerationFileHandler newGfh = new GenerationFileHandler(this.filenameSeries, this.shouldManifest);
        newGfh.setFormatter(this.getFormatter());
        return newGfh;
    }

    public boolean shouldManifest() {
        return this.shouldManifest;
    }
}

