/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.archive.io.CharSubSequence;
import org.archive.io.ReplayCharSequence;
import org.archive.io.ReplayInputStream;

public class GenericReplayCharSequence
implements ReplayCharSequence {
    protected static Logger logger = Logger.getLogger(GenericReplayCharSequence.class.getName());
    private static final String WRITE_ENCODING = "UTF-16BE";
    private CharBuffer content = null;
    private File decodedFile = null;

    public GenericReplayCharSequence(byte[] buffer, long size, long responseBodyStart, String encoding) throws IOException {
        this.content = this.decodeInMemory(buffer, size, responseBodyStart, encoding);
    }

    public GenericReplayCharSequence(ReplayInputStream contentReplayInputStream, String backingFilename, String characterEncoding) throws IOException {
        this.content = this.decodeToFile(contentReplayInputStream, backingFilename, characterEncoding);
    }

    private CharBuffer decodeToFile(ReplayInputStream inStream, String backingFilename, String encoding) throws IOException {
        int c;
        FileOutputStream fos;
        CharBuffer charBuffer = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inStream, encoding));
        this.decodedFile = new File(backingFilename + "." + WRITE_ENCODING);
        try {
            fos = new FileOutputStream(this.decodedFile);
        }
        catch (FileNotFoundException e) {
            System.gc();
            System.runFinalization();
            logger.info("Windows 'file with a user-mapped section open' workaround gc-finalization performed.");
            fos = new FileOutputStream(this.decodedFile);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, WRITE_ENCODING));
        while ((c = reader.read()) >= 0) {
            writer.write(c);
        }
        writer.close();
        charBuffer = this.getReadOnlyMemoryMappedBuffer(this.decodedFile).asCharBuffer();
        return charBuffer;
    }

    private CharBuffer decodeInMemory(byte[] buffer, long size, long responseBodyStart, String encoding) {
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.position((int)responseBodyStart);
        bb.limit((int)size);
        return Charset.forName(encoding).decode(bb).asReadOnlyBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getReadOnlyMemoryMappedBuffer(File file) throws IOException {
        ByteBuffer bb = null;
        FileInputStream in = null;
        AbstractInterruptibleChannel c = null;
        assert (file.exists()) : "No file " + file.getAbsolutePath();
        try {
            in = new FileInputStream(file);
            c = in.getChannel();
            bb = ((FileChannel)c).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)c).size()).asReadOnlyBuffer();
        }
        finally {
            if (c != null && c.isOpen()) {
                c.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return bb;
    }

    private void deleteFile(File fileToDelete) {
        this.deleteFile(fileToDelete, null);
    }

    private void deleteFile(File fileToDelete, Exception e) {
        if (e != null) {
            logger.severe("Deleting " + fileToDelete + " because of " + e.toString());
        }
        if (fileToDelete != null && fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }

    public void close() {
        this.content = null;
        this.deleteFile(this.decodedFile);
        this.decodedFile = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public int length() {
        return this.content.limit();
    }

    public char charAt(int index) {
        return this.content.get(index);
    }

    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(this, start, end);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }
}

