/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.archive.io.NoGzipMagicException;

public class GzipHeader {
    public static final int MINIMAL_GZIP_HEADER_LENGTH = 10;
    protected int length = 0;
    protected int flg;
    private int xfl;
    private int os;
    private byte[] fextra = null;
    private int mtime;

    public GzipHeader() {
    }

    public GzipHeader(InputStream in) throws IOException {
        this.readHeader(in);
    }

    public void readHeader(InputStream in) throws IOException {
        CRC32 crc = new CRC32();
        crc.reset();
        if (!this.testGzipMagic(in, crc)) {
            throw new NoGzipMagicException();
        }
        this.length += 2;
        if (this.readByte(in, crc) != 8) {
            throw new IOException("Unknown compression");
        }
        ++this.length;
        this.flg = this.readByte(in, crc);
        ++this.length;
        this.mtime = this.readInt(in, crc);
        this.length += 4;
        this.xfl = this.readByte(in, crc);
        ++this.length;
        this.os = this.readByte(in, crc);
        ++this.length;
        int FLG_FEXTRA = 4;
        if ((this.flg & 4) == 4) {
            int count = this.readShort(in, crc);
            this.length += 2;
            this.fextra = new byte[count];
            this.readByte(in, crc, this.fextra, 0, count);
            this.length += count;
        }
        int FLG_FNAME = 8;
        if ((this.flg & 8) == 8) {
            while (this.readByte(in, crc) != 0) {
                ++this.length;
            }
        }
        int FLG_FCOMMENT = 16;
        if ((this.flg & 0x10) == 16) {
            while (this.readByte(in, crc) != 0) {
                ++this.length;
            }
        }
        int FLG_FHCRC = 2;
        if ((this.flg & 2) == 2) {
            int calcCrc = (int)(crc.getValue() & 0xFFFFL);
            if (this.readShort(in, crc) != calcCrc) {
                throw new IOException("Bad header CRC");
            }
            this.length += 2;
        }
    }

    public boolean testGzipMagic(InputStream in) throws IOException {
        return this.testGzipMagic(in, null);
    }

    public boolean testGzipMagic(InputStream in, CRC32 crc) throws IOException {
        return this.readShort(in, crc) == 35615;
    }

    private int readInt(InputStream in, CRC32 crc) throws IOException {
        int s = this.readShort(in, crc);
        return this.readShort(in, crc) << 16 & 0xFFFF0000 | s;
    }

    private int readShort(InputStream in, CRC32 crc) throws IOException {
        int b = this.readByte(in, crc);
        return this.readByte(in, crc) << 8 & 0xFF00 | b;
    }

    protected int readByte(InputStream in) throws IOException {
        return this.readByte(in, null);
    }

    protected int readByte(InputStream in, CRC32 crc) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (crc != null) {
            crc.update(b);
        }
        return b & 0xFF;
    }

    protected int readByte(InputStream in, CRC32 crc, byte[] buffer, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            buffer[offset + i] = (byte)this.readByte(in, crc);
        }
        return length;
    }

    public byte[] getFextra() {
        return this.fextra;
    }

    public int getFlg() {
        return this.flg;
    }

    public int getOs() {
        return this.os;
    }

    public int getXfl() {
        return this.xfl;
    }

    public int getMtime() {
        return this.mtime;
    }

    public int getLength() {
        return this.length;
    }
}

