/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.archive.io.GzipHeader;
import org.archive.io.NoGzipMagicException;

public class GzippedInputStream
extends GZIPInputStream
implements RepositionableStream {
    private static final int GZIP_TRAILER_LENGTH = 8;
    private final GzipHeader gzipHeader = new GzipHeader();
    private static final int LINUX_PAGE_SIZE = 4096;
    private final long initialOffset;

    public GzippedInputStream(InputStream is) throws IOException {
        this(is, 4096);
    }

    public GzippedInputStream(InputStream is, int size) throws IOException {
        super(GzippedInputStream.checkStream(is), size);
        if (!is.markSupported()) {
            throw new IllegalArgumentException("GzippedInputStream requires a markable stream");
        }
        if (!(is instanceof RepositionableStream)) {
            throw new IllegalArgumentException("GzippedInputStream requires a stream that implements RepositionableStream");
        }
        long afterGZIPHeader = ((RepositionableStream)is).position();
        is.reset();
        this.initialOffset = ((RepositionableStream)is).position();
        ((RepositionableStream)is).position(afterGZIPHeader);
    }

    protected static InputStream checkStream(InputStream is) throws IOException {
        if (is instanceof RepositionableStream) {
            is.mark(40);
            return is;
        }
        throw new IOException("Passed stream does not implement PositionableStream");
    }

    public long gotoEOR(int ignore) throws IOException {
        long bytesSkipped = 0L;
        if (this.inf.getTotalIn() <= 0) {
            return bytesSkipped;
        }
        if (!this.inf.finished()) {
            int read = 0;
            while ((read = this.read()) != -1) {
                if ((byte)read == (byte)ignore) continue;
                bytesSkipped = this.gotoEOR() + 1L;
                break;
            }
        }
        return bytesSkipped;
    }

    public long gotoEOR() throws IOException {
        long bytesSkipped = 0L;
        if (this.inf.getTotalIn() <= 0) {
            return bytesSkipped;
        }
        while (!this.inf.finished()) {
            bytesSkipped += this.skip(Long.MAX_VALUE);
        }
        return bytesSkipped;
    }

    public Iterator iterator() {
        final Logger logger = Logger.getLogger(this.getClass().getName());
        try {
            ((RepositionableStream)this.in).position(this.initialOffset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Iterator(){
            private GzippedInputStream compressedStream;
            {
                this.compressedStream = GzippedInputStream.this;
            }

            public boolean hasNext() {
                try {
                    GzippedInputStream.this.gotoEOR();
                }
                catch (IOException e) {
                    if (e instanceof ZipException || e.getMessage() != null && e.getMessage().startsWith("Corrupt GZIP trailer")) {
                        logger.info("Skipping exception " + e.getMessage());
                    }
                    throw new RuntimeException(e);
                }
                return GzippedInputStream.this.moveToNextGzipMember();
            }

            public Object next() {
                try {
                    GzippedInputStream.this.gzipMemberSeek();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed move to EOR or failed header read: " + e.getMessage());
                }
                return this.compressedStream;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean moveToNextGzipMember() {
        boolean result = false;
        try {
            RepositionableStream ps = (RepositionableStream)this.getInputStream();
            if (this.getInflater().getRemaining() > 8) {
                ps.position(this.position() - (long)this.getInflater().getRemaining() + 8L);
            }
            int read = -1;
            int headerRead = 0;
            while (true) {
                this.getInputStream().mark(3);
                read = this.getInputStream().read();
                if (read == -1) break;
                if (this.compareBytes(read, 35615)) {
                    ++headerRead;
                    read = this.getInputStream().read();
                    if (read == -1) break;
                    if (this.compareBytes(read, 139)) {
                        ++headerRead;
                        read = this.getInputStream().read();
                        if (read == -1) break;
                        if (this.compareBytes(read, 8)) {
                            ++headerRead;
                            this.getInputStream().reset();
                            result = true;
                            break;
                        }
                    }
                    ps.position(ps.position() - (long)headerRead);
                }
                headerRead = 0;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed i/o: " + e.getMessage());
        }
        return result;
    }

    protected boolean compareBytes(int a, int b) {
        return (byte)(a & 0xFF) == (byte)(b & 0xFF);
    }

    protected Inflater getInflater() {
        return this.inf;
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    protected GzipHeader getGzipHeader() {
        return this.gzipHeader;
    }

    protected void resetInflater() {
        this.eos = false;
        this.inf.reset();
    }

    protected void readHeader() throws IOException {
        new GzipHeader(this.in);
        this.crc.reset();
    }

    public void position(long position) throws IOException {
        ((RepositionableStream)this.in).position(position);
        this.resetInflater();
    }

    public long position() throws IOException {
        return ((RepositionableStream)this.in).position();
    }

    public void gzipMemberSeek(long position) throws IOException {
        this.position(position);
        this.readHeader();
    }

    public void gzipMemberSeek() throws IOException {
        this.gzipMemberSeek(this.position());
    }

    public static byte[] gzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOS = new GZIPOutputStream(baos);
        gzipOS.write(bytes, 0, bytes.length);
        gzipOS.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompressedRepositionableStream(RepositionableStream rs) throws IOException {
        boolean result = false;
        long p = rs.position();
        try {
            result = GzippedInputStream.isCompressedStream((InputStream)rs);
        }
        finally {
            rs.position(p);
        }
        return result;
    }

    public static boolean isCompressedStream(InputStream is) throws IOException {
        try {
            new GzipHeader(is);
        }
        catch (NoGzipMagicException e) {
            return false;
        }
        return true;
    }
}

