/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.RecoverableIOException;

public class HeaderedArchiveRecord
extends ArchiveRecord {
    private int contentHeadersLength = -1;
    private int statusCode = -1;
    private InputStream contentHeaderStream = null;
    private Header[] contentHeaders = null;

    public HeaderedArchiveRecord(ArchiveRecord ar) throws IOException {
        super(ar);
    }

    public HeaderedArchiveRecord(ArchiveRecord ar, boolean readContentHeader) throws IOException {
        super(ar);
        if (readContentHeader) {
            this.contentHeaderStream = this.readContentHeaders();
        }
    }

    public void skipHttpHeader() throws IOException {
        if (this.contentHeaderStream == null) {
            return;
        }
        int available = this.contentHeaderStream.available();
        while (this.contentHeaderStream != null && (available = this.contentHeaderStream.available()) > 0) {
            byte[] buffer = new byte[available];
            this.read(buffer, 0, available);
        }
    }

    public void dumpHttpHeader() throws IOException {
        this.dumpHttpHeader(System.out);
    }

    public void dumpHttpHeader(PrintStream stream) throws IOException {
        if (this.contentHeaderStream == null) {
            return;
        }
        int available = this.contentHeaderStream.available();
        while (this.contentHeaderStream != null && (available = this.contentHeaderStream.available()) > 0) {
            byte[] buffer = new byte[available];
            int read = this.read(buffer, 0, available);
            stream.write(buffer, 0, read);
        }
    }

    private InputStream readContentHeaders() throws IOException {
        if (!this.hasContentHeaders()) {
            return null;
        }
        byte[] statusBytes = HttpParser.readRawLine(this.getIn());
        int eolCharCount = this.getEolCharsCount(statusBytes);
        if (eolCharCount <= 0) {
            throw new IOException("Failed to read raw lie where one  was expected: " + new String(statusBytes));
        }
        String statusLine = EncodingUtil.getString((byte[])statusBytes, (int)0, (int)(statusBytes.length - eolCharCount), (String)"ISO-8859-1");
        if (statusLine == null) {
            throw new NullPointerException("Expected status line is null");
        }
        boolean isHttpResponse = StatusLine.startsWithHTTP((String)statusLine);
        boolean isHttpRequest = false;
        if (!isHttpResponse) {
            boolean bl = isHttpRequest = statusLine.toUpperCase().startsWith("GET") || !statusLine.toUpperCase().startsWith("POST");
        }
        if (!isHttpResponse && !isHttpRequest) {
            throw new UnexpectedStartLineIOException("Failed parse of status line: " + statusLine);
        }
        this.statusCode = isHttpResponse ? new StatusLine(statusLine).getStatusCode() : -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(statusBytes.length + 4096);
        baos.write(statusBytes);
        byte[] lineBytes = null;
        do {
            if ((eolCharCount = this.getEolCharsCount(lineBytes = HttpParser.readRawLine(this.getIn()))) <= 0) {
                throw new IOException("Failed reading headers: " + (lineBytes != null ? new String(lineBytes) : null));
            }
            baos.write(lineBytes);
        } while (lineBytes.length - eolCharCount > 0);
        byte[] headerBytes = baos.toByteArray();
        this.contentHeadersLength = headerBytes.length;
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        if (!bais.markSupported()) {
            throw new IOException("ByteArrayInputStream does not support mark");
        }
        bais.mark(headerBytes.length);
        bais.read(statusBytes, 0, statusBytes.length);
        this.contentHeaders = HttpParser.parseHeaders(bais, "ISO-8859-1");
        bais.reset();
        return bais;
    }

    private int getEolCharsCount(byte[] bytes) {
        int count = 0;
        if (bytes != null && bytes.length >= 1 && bytes[bytes.length - 1] == 10) {
            ++count;
            if (bytes.length >= 2 && bytes[bytes.length - 2] == 13) {
                ++count;
            }
        }
        return count;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getContentHeadersLength() {
        return this.contentHeadersLength;
    }

    public Header[] getContentHeaders() {
        return this.contentHeaders;
    }

    public int read() throws IOException {
        int c = -1;
        if (this.contentHeaderStream != null && this.contentHeaderStream.available() > 0) {
            c = this.contentHeaderStream.read();
            if (this.contentHeaderStream.available() <= 0) {
                this.contentHeaderStream = null;
            }
        } else {
            c = super.read();
        }
        return c;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int read = -1;
        if (this.contentHeaderStream != null && this.contentHeaderStream.available() > 0) {
            read = Math.min(length, this.contentHeaderStream.available());
            read = read == 0 ? -1 : this.contentHeaderStream.read(b, offset, read);
            if (this.contentHeaderStream.available() <= 0) {
                this.contentHeaderStream = null;
            }
        } else {
            read = super.read(b, offset, length);
        }
        return read;
    }

    public int available() {
        return ((ArchiveRecord)this.in).available();
    }

    public void close() throws IOException {
        ((ArchiveRecord)this.in).close();
    }

    public void dump() throws IOException {
        ((ArchiveRecord)this.in).dump();
    }

    public void dump(OutputStream os) throws IOException {
        ((ArchiveRecord)this.in).dump(os);
    }

    protected String getDigest4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getDigest4Cdx(h);
    }

    public String getDigestStr() {
        return ((ArchiveRecord)this.in).getDigestStr();
    }

    public ArchiveRecordHeader getHeader() {
        return ((ArchiveRecord)this.in).getHeader();
    }

    protected String getIp4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getIp4Cdx(h);
    }

    protected String getMimetype4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getMimetype4Cdx(h);
    }

    protected long getPosition() {
        return ((ArchiveRecord)this.in).getPosition();
    }

    protected String getStatusCode4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getStatusCode4Cdx(h);
    }

    public boolean hasContentHeaders() {
        return ((ArchiveRecord)this.in).hasContentHeaders();
    }

    protected void incrementPosition() {
        ((ArchiveRecord)this.in).incrementPosition();
    }

    protected void incrementPosition(long incr) {
        ((ArchiveRecord)this.in).incrementPosition(incr);
    }

    protected boolean isEor() {
        return ((ArchiveRecord)this.in).isEor();
    }

    public boolean isStrict() {
        return ((ArchiveRecord)this.in).isStrict();
    }

    public boolean markSupported() {
        return ((ArchiveRecord)this.in).markSupported();
    }

    protected String outputCdx(String strippedFileName) throws IOException {
        return ((ArchiveRecord)this.in).outputCdx(strippedFileName);
    }

    protected void setEor(boolean eor) {
        ((ArchiveRecord)this.in).setEor(eor);
    }

    protected void setHeader(ArchiveRecordHeader header) {
        ((ArchiveRecord)this.in).setHeader(header);
    }

    public void setStrict(boolean strict) {
        ((ArchiveRecord)this.in).setStrict(strict);
    }

    void skip() throws IOException {
        ((ArchiveRecord)this.in).skip();
    }

    public long skip(long n) throws IOException {
        return ((ArchiveRecord)this.in).skip(n);
    }

    public static class UnexpectedStartLineIOException
    extends RecoverableIOException {
        public UnexpectedStartLineIOException(String reason) {
            super(reason);
        }
    }
}

