/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.CharSubSequence;
import org.archive.io.ReplayCharSequence;
import org.archive.util.DevUtils;

class Latin1ByteReplayCharSequence
implements ReplayCharSequence {
    protected static Logger logger = Logger.getLogger(Latin1ByteReplayCharSequence.class.getName());
    private byte[] prefixBuffer;
    protected int length;
    private int absoluteLength = -1;
    private byte[] wraparoundBuffer;
    private int wrapOrigin;
    private int wrapOffset;
    private String backingFilename;
    private RandomAccessFile raFile;
    private int contentOffset;
    private static final String DEFAULT_SINGLE_BYTE_ENCODING = "ISO-8859-1";

    public Latin1ByteReplayCharSequence(byte[] buffer, long size, long responseBodyStart, String backingFilename) throws IOException {
        this.length = (int)(size - responseBodyStart);
        this.absoluteLength = (int)size;
        this.prefixBuffer = buffer;
        this.contentOffset = (int)responseBodyStart;
        if (size > (long)buffer.length) {
            this.backingFilename = backingFilename;
            this.raFile = new RandomAccessFile(backingFilename, "r");
            this.wraparoundBuffer = new byte[this.prefixBuffer.length];
            this.wrapOrigin = this.prefixBuffer.length;
            this.wrapOffset = 0;
            this.loadBuffer();
        }
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        int c = -1;
        c = (index += this.contentOffset) < this.prefixBuffer.length ? this.prefixBuffer[index] : (index >= this.wrapOrigin && index - this.wrapOrigin < this.wraparoundBuffer.length ? this.wraparoundBuffer[(index - this.wrapOrigin + this.wrapOffset) % this.wraparoundBuffer.length] : this.faultCharAt(index));
        return (char)(c & 0xFF);
    }

    private int faultCharAt(int index) {
        if (Thread.interrupted()) {
            throw new RuntimeException("thread interrupted");
        }
        if (index >= this.wrapOrigin + this.wraparoundBuffer.length) {
            while (index >= this.wrapOrigin + this.wraparoundBuffer.length) {
                this.advanceBuffer();
            }
            return this.charAt(index - this.contentOffset);
        }
        this.recenterBuffer(index);
        return this.charAt(index - this.contentOffset);
    }

    private void recenterBuffer(int index) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Recentering around " + index + " in " + this.backingFilename);
        }
        this.wrapOrigin = index - this.wraparoundBuffer.length / 2;
        if (this.wrapOrigin < this.prefixBuffer.length) {
            this.wrapOrigin = this.prefixBuffer.length;
        }
        this.wrapOffset = 0;
        this.loadBuffer();
    }

    private void loadBuffer() {
        long len = -1L;
        try {
            len = this.raFile.length();
            this.raFile.seek(this.wrapOrigin - this.prefixBuffer.length);
            this.raFile.readFully(this.wraparoundBuffer, 0, Math.min(this.wraparoundBuffer.length, this.absoluteLength - this.wrapOrigin));
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "raFile.seek(" + (this.wrapOrigin - this.prefixBuffer.length) + ")\n" + "raFile.readFully(wraparoundBuffer,0," + Math.min(this.wraparoundBuffer.length, this.length - this.wrapOrigin) + ")\n" + "raFile.length()" + len + "\n" + DevUtils.extraInfo(), e);
            throw new RuntimeException(e);
        }
    }

    private void advanceBuffer() {
        try {
            this.wraparoundBuffer[this.wrapOffset] = (byte)this.raFile.read();
            ++this.wrapOffset;
            this.wrapOffset %= this.wraparoundBuffer.length;
            ++this.wrapOrigin;
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "advanceBuffer()" + DevUtils.extraInfo(), e);
            throw new RuntimeException(e);
        }
    }

    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(this, start, end);
    }

    public void close() throws IOException {
        this.prefixBuffer = null;
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public String substring(int offset, int len) {
        return ((Object)this.subSequence(offset, offset + len)).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        sb.append(this);
        return sb.toString();
    }
}

