/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.io.RecordingOutputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.io.ReplayInputStream;

public class RecordingInputStream
extends InputStream {
    protected static Logger logger = Logger.getLogger("org.archive.io.RecordingInputStream");
    private RecordingOutputStream recordingOutputStream;
    private InputStream in = null;
    protected byte[] drainBuffer = new byte[16384];

    public RecordingInputStream(int bufferSize, String backingFilename) {
        this.recordingOutputStream = new RecordingOutputStream(bufferSize, backingFilename);
    }

    public void open(InputStream wrappedStream) throws IOException {
        logger.fine(Thread.currentThread().getName() + " opening " + wrappedStream + ", " + Thread.currentThread().getName());
        if (this.isOpen()) {
            throw new IOException("RIS already open for " + Thread.currentThread().getName());
        }
        this.in = wrappedStream;
        this.recordingOutputStream.open();
    }

    public int read() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int b = this.in.read();
        if (b != -1) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b);
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int count = this.in.read(b, off, len);
        if (count > 0) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b, off, count);
        }
        return count;
    }

    public int read(byte[] b) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int count = this.in.read(b);
        if (count > 0) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b, 0, count);
        }
        return count;
    }

    public void close() throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Thread.currentThread().getName() + " closing " + this.in + ", " + Thread.currentThread().getName());
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.recordingOutputStream.close();
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.recordingOutputStream.getReplayInputStream();
    }

    public ReplayInputStream getContentReplayInputStream() throws IOException {
        return this.recordingOutputStream.getContentReplayInputStream();
    }

    public long readFully() throws IOException {
        while (this.read(this.drainBuffer) != -1) {
        }
        return this.recordingOutputStream.getSize();
    }

    public void readFullyOrUntil(long softMaxLength) throws IOException, RecorderLengthExceededException, RecorderTimeoutException, InterruptedException {
        if (!this.isOpen()) {
            return;
        }
        long totalBytes = 0L;
        long bytesRead = -1L;
        long maxToRead = -1L;
        do {
            try {
                maxToRead = softMaxLength <= 0L ? (long)this.drainBuffer.length : Math.min((long)this.drainBuffer.length, softMaxLength - totalBytes);
                maxToRead = Math.min(maxToRead, this.recordingOutputStream.getRemainingLength());
                maxToRead = Math.max(maxToRead, 1L);
                bytesRead = this.read(this.drainBuffer, 0, (int)maxToRead);
                if (bytesRead != -1L) {
                    totalBytes += bytesRead;
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Interrupted during IO");
                }
                break;
            }
            catch (SocketTimeoutException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "socket timeout", e);
                }
                this.recordingOutputStream.checkLimits();
            }
            catch (SocketException se) {
                throw se;
            }
            catch (NullPointerException e) {
                throw new NullPointerException("Stream " + this.in + ", " + e.getMessage() + " " + Thread.currentThread().getName());
            }
        } while (softMaxLength <= 0L || totalBytes < softMaxLength);
    }

    public long getSize() {
        return this.recordingOutputStream.getSize();
    }

    public void markContentBegin() {
        this.recordingOutputStream.markContentBegin();
    }

    public long getContentBegin() {
        return this.recordingOutputStream.getContentBegin();
    }

    public void startDigest() {
        this.recordingOutputStream.startDigest();
    }

    public void setSha1Digest() {
        this.recordingOutputStream.setSha1Digest();
    }

    public void setDigest(String algorithm) {
        this.recordingOutputStream.setDigest(algorithm);
    }

    public void setDigest(MessageDigest md) {
        this.recordingOutputStream.setDigest(md);
    }

    public byte[] getDigestValue() {
        return this.recordingOutputStream.getDigestValue();
    }

    public ReplayCharSequence getReplayCharSequence() throws IOException {
        return this.getReplayCharSequence(null);
    }

    public ReplayCharSequence getReplayCharSequence(String characterEncoding) throws IOException {
        return this.recordingOutputStream.getReplayCharSequence(characterEncoding);
    }

    public long getResponseContentLength() {
        return this.recordingOutputStream.getResponseContentLength();
    }

    public void closeRecorder() throws IOException {
        this.recordingOutputStream.closeRecorder();
    }

    public void copyContentBodyTo(File tempFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(tempFile);
        ReplayInputStream ris = this.getContentReplayInputStream();
        ris.readFullyTo(fos);
        fos.close();
        ris.close();
    }

    public boolean isOpen() {
        return this.in != null;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.recordingOutputStream.mark();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.recordingOutputStream.reset();
    }

    public void setLimits(long hardMax, long timeoutMs, long maxRateKBps) {
        this.recordingOutputStream.setLimits(hardMax, timeoutMs, maxRateKBps);
    }
}

