/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.GenericReplayCharSequence;
import org.archive.io.Latin1ByteReplayCharSequence;
import org.archive.io.RecorderIOException;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.io.RecorderTooMuchHeaderException;
import org.archive.io.RecyclingFastBufferedOutputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.io.ReplayInputStream;

public class RecordingOutputStream
extends OutputStream {
    protected static Logger logger = Logger.getLogger(RecordingOutputStream.class.getName());
    private long size = 0L;
    private String backingFilename;
    private OutputStream diskStream = null;
    private byte[] buffer;
    private long position;
    private boolean recording;
    protected byte[] bufStreamBuf = new byte[8192];
    private boolean shouldDigest = false;
    private MessageDigest digest = null;
    private static final String SHA1 = "SHA1";
    protected static final long MAX_HEADER_MATERIAL = 0x100000L;
    protected long maxLength = Long.MAX_VALUE;
    protected long timeoutMs = Long.MAX_VALUE;
    protected long maxRateBytesPerMs = Long.MAX_VALUE;
    protected long startTime = Long.MAX_VALUE;
    private long contentBeginMark;
    private OutputStream out = null;
    private long maxPosition = 0L;
    private long markPosition = 0L;
    private static final String canonicalLatin1 = Charset.forName("iso8859-1").name();

    public RecordingOutputStream(int bufferSize, String backingFilename) {
        this.buffer = new byte[bufferSize];
        this.backingFilename = backingFilename;
        this.recording = true;
    }

    public void open() throws IOException {
        this.open(null);
    }

    public void open(OutputStream wrappedStream) throws IOException {
        if (this.isOpen()) {
            throw new IOException("ROS already open for " + Thread.currentThread().getName());
        }
        this.out = wrappedStream;
        this.position = 0L;
        this.markPosition = 0L;
        this.maxPosition = 0L;
        this.size = 0L;
        this.contentBeginMark = -1L;
        this.recording = true;
        this.shouldDigest = false;
        if (this.diskStream != null) {
            this.closeDiskStream();
        }
        if (this.diskStream == null) {
            FileOutputStream fis = new FileOutputStream(this.backingFilename);
            this.diskStream = new RecyclingFastBufferedOutputStream((OutputStream)fis, this.bufStreamBuf);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void write(int b) throws IOException {
        if (this.position < this.maxPosition) {
            ++this.position;
            return;
        }
        if (this.recording) {
            this.record(b);
        }
        if (this.out != null) {
            this.out.write(b);
        }
        this.checkLimits();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.position < this.maxPosition) {
            if (this.position + (long)len <= this.maxPosition) {
                this.position += (long)len;
                return;
            }
            long consumeRange = this.maxPosition - this.position;
            this.position += consumeRange;
            off = (int)((long)off + consumeRange);
            len = (int)((long)len - consumeRange);
        }
        if (this.recording) {
            this.record(b, off, len);
        }
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        this.checkLimits();
    }

    protected void checkLimits() throws RecorderIOException {
        if (this.contentBeginMark < 0L && this.position > 0x100000L) {
            throw new RecorderTooMuchHeaderException();
        }
        if (this.position > this.maxLength) {
            throw new RecorderLengthExceededException();
        }
        long duration = System.currentTimeMillis() - this.startTime;
        if ((duration = Math.max(duration, 1L)) > this.timeoutMs) {
            throw new RecorderTimeoutException();
        }
        if (this.position / duration > this.maxRateBytesPerMs) {
            long desiredDuration = this.position / this.maxRateBytesPerMs;
            try {
                Thread.sleep(desiredDuration - duration);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "bandwidth throttling sleep interrupted", e);
            }
        }
    }

    private void record(int b) throws IOException {
        if (this.shouldDigest) {
            this.digest.update((byte)b);
        }
        if (this.position >= (long)this.buffer.length) {
            assert (this.diskStream != null) : "Diskstream is null";
            this.diskStream.write(b);
        } else {
            this.buffer[(int)this.position] = (byte)b;
        }
        ++this.position;
    }

    private void record(byte[] b, int off, int len) throws IOException {
        if (this.shouldDigest) {
            assert (this.digest != null) : "Digest is null.";
            this.digest.update(b, off, len);
        }
        this.tailRecord(b, off, len);
    }

    private void tailRecord(byte[] b, int off, int len) throws IOException {
        if (this.position >= (long)this.buffer.length) {
            if (this.diskStream == null) {
                throw new IOException("diskstream is null");
            }
            this.diskStream.write(b, off, len);
            this.position += (long)len;
        } else {
            assert (this.buffer != null) : "Buffer is null";
            int toCopy = (int)Math.min((long)this.buffer.length - this.position, (long)len);
            assert (b != null) : "Passed buffer is null";
            System.arraycopy(b, off, this.buffer, (int)this.position, toCopy);
            this.position += (long)toCopy;
            if (toCopy < len) {
                this.tailRecord(b, off + toCopy, len - toCopy);
            }
        }
    }

    public void close() throws IOException {
        if (this.contentBeginMark < 0L) {
            this.contentBeginMark = 0L;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        this.closeRecorder();
    }

    protected synchronized void closeDiskStream() throws IOException {
        if (this.diskStream != null) {
            this.diskStream.close();
            this.diskStream = null;
        }
    }

    public void closeRecorder() throws IOException {
        this.recording = false;
        this.closeDiskStream();
        if (this.size == 0L) {
            this.size = this.position;
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.diskStream != null) {
            this.diskStream.flush();
        }
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.getReplayInputStream(0L);
    }

    public ReplayInputStream getReplayInputStream(long skip) throws IOException {
        assert (this.out == null) : "Stream is still open.";
        ReplayInputStream replay = new ReplayInputStream(this.buffer, this.size, this.contentBeginMark, this.backingFilename);
        replay.skip(skip);
        return replay;
    }

    public ReplayInputStream getContentReplayInputStream() throws IOException {
        return this.getReplayInputStream(this.contentBeginMark);
    }

    public long getSize() {
        return this.size;
    }

    public void markContentBegin() {
        this.contentBeginMark = this.position;
        this.startDigest();
    }

    public long getContentBegin() {
        return this.contentBeginMark;
    }

    public void startDigest() {
        if (this.digest != null) {
            this.digest.reset();
            this.shouldDigest = true;
        }
    }

    public void setSha1Digest() {
        this.setDigest(SHA1);
    }

    public void setDigest(String algorithm) {
        try {
            if (this.digest == null || !this.digest.getAlgorithm().equals(algorithm)) {
                this.setDigest(MessageDigest.getInstance(algorithm));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setDigest(MessageDigest md) {
        this.digest = md;
    }

    public byte[] getDigestValue() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.digest();
    }

    public ReplayCharSequence getReplayCharSequence() throws IOException {
        return this.getReplayCharSequence(null);
    }

    public ReplayCharSequence getReplayCharSequence(String characterEncoding) throws IOException {
        return this.getReplayCharSequence(characterEncoding, this.contentBeginMark);
    }

    public ReplayCharSequence getReplayCharSequence(String characterEncoding, long startOffset) throws IOException {
        if (characterEncoding == null) {
            characterEncoding = Charset.defaultCharset().name();
        }
        if (canonicalLatin1.equals(Charset.forName(characterEncoding).name())) {
            return new Latin1ByteReplayCharSequence(this.buffer, this.size, startOffset, this.backingFilename);
        }
        if (this.size <= (long)this.buffer.length) {
            return new GenericReplayCharSequence(this.buffer, this.size, startOffset, characterEncoding);
        }
        ReplayInputStream ris = this.getReplayInputStream(startOffset);
        GenericReplayCharSequence rcs = new GenericReplayCharSequence(ris, this.backingFilename, characterEncoding);
        ris.close();
        return rcs;
    }

    public long getResponseContentLength() {
        return this.size - this.contentBeginMark;
    }

    public boolean isOpen() {
        return this.out != null;
    }

    public void mark() {
        this.markPosition = this.position;
    }

    public void reset() {
        this.maxPosition = Math.max(this.maxPosition, this.position);
        this.position = this.markPosition;
    }

    public void setLimits(long length, long milliseconds, long rateKBps) {
        this.maxLength = length > 0L ? length : Long.MAX_VALUE;
        this.timeoutMs = milliseconds > 0L ? milliseconds : Long.MAX_VALUE;
        this.maxRateBytesPerMs = rateKBps > 0L ? rateKBps * 1024L / 1000L : Long.MAX_VALUE;
    }

    public void resetLimits() {
        this.maxLength = Long.MAX_VALUE;
        this.timeoutMs = Long.MAX_VALUE;
        this.maxRateBytesPerMs = Long.MAX_VALUE;
    }

    public long getRemainingLength() {
        return this.maxLength - this.position;
    }
}

