/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import java.io.OutputStream;

public class RecyclingFastBufferedOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected byte[] buffer;
    protected int pos;
    protected int avail;
    protected OutputStream os;

    public RecyclingFastBufferedOutputStream(OutputStream os, byte[] buffer) {
        this.os = os;
        this.buffer = buffer;
        this.avail = buffer.length;
    }

    public RecyclingFastBufferedOutputStream(OutputStream os, int bufSize) {
        this(os, new byte[bufSize]);
    }

    public RecyclingFastBufferedOutputStream(OutputStream os) {
        this(os, 16384);
    }

    private void dumpBufferIfFull() throws IOException {
        if (this.avail == 0) {
            this.os.write(this.buffer);
            this.pos = 0;
            this.avail = this.buffer.length;
        }
    }

    public void write(int b) throws IOException {
        --this.avail;
        this.buffer[this.pos++] = (byte)b;
        this.dumpBufferIfFull();
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (length <= this.avail) {
            System.arraycopy(b, offset, this.buffer, this.pos, length);
            this.pos += length;
            this.avail -= length;
            this.dumpBufferIfFull();
            return;
        }
        System.arraycopy(b, offset, this.buffer, this.pos, this.avail);
        this.os.write(this.buffer);
        int residual = (length -= this.avail) % this.buffer.length;
        this.os.write(b, offset += this.avail, length - residual);
        System.arraycopy(b, offset + length - residual, this.buffer, 0, residual);
        this.pos = residual;
        this.avail = this.buffer.length - residual;
    }

    public void close() throws IOException {
        if (this.os == null) {
            return;
        }
        if (this.pos != 0) {
            this.os.write(this.buffer, 0, this.pos);
        }
        if (this.os != System.out) {
            this.os.close();
        }
        this.os = null;
        this.buffer = null;
    }
}

