/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.archive.io.RecordingOutputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.util.FileUtils;
import org.archive.util.TmpDirTestCase;

public class ReplayCharSequenceTest
extends TmpDirTestCase {
    private static Logger logger = Logger.getLogger("org.archive.io.ReplayCharSequenceFactoryTest");
    private static final int SEQUENCE_LENGTH = 127;
    private static final int MULTIPLIER = 3;
    private static final int BUFFER_SIZE = 381;
    private static final int INCREMENT = 1;
    private byte[] regularBuffer = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.regularBuffer = this.fillBufferWithRegularContent(new byte[381]);
    }

    public void testShiftjis() throws IOException {
        byte[] bytes_nihongo = new byte[]{27, 36, 66, 70, 124, 75, 92, 56, 108, 27, 40, 66, 27, 40, 66};
        String ENCODING = "SJIS";
        String nihongo = new String(bytes_nihongo, "SJIS");
        RecordingOutputStream ros = this.writeTestStream(bytes_nihongo, 3, "testShiftjis", 3);
        ReplayCharSequence rcs = ros.getReplayCharSequence("SJIS");
        String rcsStr = ((Object)rcs.subSequence(0, nihongo.length())).toString();
        ReplayCharSequenceTest.assertTrue((String)("Nihongo " + nihongo + " does not equal converted string" + " from rcs " + rcsStr), (boolean)nihongo.equals(rcsStr));
        if (rcs.length() >= nihongo.length() * 2) {
            rcsStr = ((Object)rcs.subSequence(nihongo.length(), nihongo.length() + nihongo.length())).toString();
            ReplayCharSequenceTest.assertTrue((String)("Nihongo " + nihongo + " does not equal converted " + " string from rcs (2nd time)" + rcsStr), (boolean)nihongo.equals(rcsStr));
        }
    }

    public void testGetReplayCharSequenceByteZeroOffset() throws IOException {
        RecordingOutputStream ros = this.writeTestStream(this.regularBuffer, 3, "testGetReplayCharSequenceByteZeroOffset", 3);
        ReplayCharSequence rcs = ros.getReplayCharSequence();
        for (int i = 0; i < 3; ++i) {
            this.accessingCharacters(rcs);
        }
    }

    public void testGetReplayCharSequenceByteOffset() throws IOException {
        RecordingOutputStream ros = this.writeTestStream(this.regularBuffer, 3, "testGetReplayCharSequenceByteOffset", 3);
        ReplayCharSequence rcs = ros.getReplayCharSequence(null, 127L);
        for (int i = 0; i < 3; ++i) {
            this.accessingCharacters(rcs);
        }
    }

    public void testGetReplayCharSequenceMultiByteZeroOffset() throws IOException {
        RecordingOutputStream ros = this.writeTestStream(this.regularBuffer, 3, "testGetReplayCharSequenceMultiByteZeroOffset", 3);
        ReplayCharSequence rcs = ros.getReplayCharSequence("UTF-8");
        for (int i = 0; i < 3; ++i) {
            this.accessingCharacters(rcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetReplayCharSequenceMultiByteOffset() throws IOException {
        RecordingOutputStream ros = this.writeTestStream(this.regularBuffer, 3, "testGetReplayCharSequenceMultiByteOffset", 3);
        ReplayCharSequence rcs = ros.getReplayCharSequence("UTF-8", 127L);
        try {
            for (int i = 0; i < 3; ++i) {
                this.accessingCharacters(rcs);
            }
        }
        finally {
            rcs.close();
        }
    }

    public void testReplayCharSequenceByteToString() throws IOException {
        String fileContent = "Some file content";
        byte[] buffer = fileContent.getBytes();
        RecordingOutputStream ros = this.writeTestStream(buffer, 1, "testReplayCharSequenceByteToString.txt", 0);
        ReplayCharSequence rcs = ros.getReplayCharSequence();
        String result = rcs.toString();
        ReplayCharSequenceTest.assertEquals((String)"Strings don't match", (String)result, (String)fileContent);
    }

    private String toHexString(String str) {
        if (str != null) {
            StringBuilder buf = new StringBuilder("{ ");
            buf.append(Integer.toString(str.charAt(0), 16));
            for (int i = 1; i < str.length(); ++i) {
                buf.append(", ");
                buf.append(Integer.toString(str.charAt(i), 16));
            }
            buf.append(" }");
            return buf.toString();
        }
        return "null";
    }

    public void testSingleByteEncodings() throws IOException {
        byte[] bytes = new byte[]{97, 98, 99, 100, 125, 126, 127, -128, -127, -126, -125, -124, -4, -3, -2, -1};
        String latin1String = new String(bytes, "latin1");
        RecordingOutputStream ros = this.writeTestStream(bytes, 1, "testSingleByteEncodings-latin1.txt", 0);
        ReplayCharSequence rcs = ros.getReplayCharSequence("latin1");
        String result = rcs.toString();
        logger.info("latin1[0] " + this.toHexString(latin1String));
        logger.info("latin1[1] " + this.toHexString(result));
        ReplayCharSequenceTest.assertEquals((String)"latin1 strings don't match", (String)result, (String)latin1String);
        String w1252String = new String(bytes, "windows-1252");
        ros = this.writeTestStream(bytes, 1, "testSingleByteEncodings-windows-1252.txt", 0);
        rcs = ros.getReplayCharSequence("windows-1252");
        result = rcs.toString();
        logger.info("windows-1252[0] " + this.toHexString(w1252String));
        logger.info("windows-1252[1] " + this.toHexString(result));
        ReplayCharSequenceTest.assertEquals((String)"windows-1252 strings don't match", (String)result, (String)w1252String);
        String asciiString = new String(bytes, "ascii");
        ros = this.writeTestStream(bytes, 1, "testSingleByteEncodings-ascii.txt", 0);
        rcs = ros.getReplayCharSequence("ascii");
        result = rcs.toString();
        logger.info("ascii[0] " + this.toHexString(asciiString));
        logger.info("ascii[1] " + this.toHexString(result));
        ReplayCharSequenceTest.assertEquals((String)"ascii strings don't match", (String)result, (String)asciiString);
    }

    public void testReplayCharSequenceByteToStringOverflow() throws IOException {
        String fileContent = "Some file content. ";
        byte[] buffer = fileContent.getBytes();
        RecordingOutputStream ros = this.writeTestStream(buffer, 1, "testReplayCharSequenceByteToString.txt", 1);
        String expectedContent = fileContent + fileContent;
        ReplayCharSequence rcs = ros.getReplayCharSequence();
        String result = rcs.toString();
        ReplayCharSequenceTest.assertEquals((String)"Strings don't match", (String)expectedContent, (String)result);
    }

    public void testReplayCharSequenceByteToStringMulti() throws IOException {
        String fileContent = "Some file content";
        byte[] buffer = fileContent.getBytes("UTF-8");
        int MULTIPLICAND = 10;
        StringBuilder sb = new StringBuilder(10 * fileContent.length());
        for (int i = 0; i < 10; ++i) {
            sb.append(fileContent);
        }
        String expectedResult = sb.toString();
        RecordingOutputStream ros = this.writeTestStream(buffer, 1, "testReplayCharSequenceByteToStringMulti.txt", 9);
        for (int i = 0; i < 3; ++i) {
            ReplayCharSequence rcs = ros.getReplayCharSequence("UTF-8");
            String result = rcs.toString();
            ReplayCharSequenceTest.assertEquals((String)"Strings don't match", (String)result, (String)expectedResult);
            rcs.close();
            System.gc();
            System.runFinalization();
        }
    }

    private void accessingCharacters(CharSequence rcs) {
        long timestamp = new Date().getTime();
        int seeks = 0;
        int i = 2;
        while (i + 1 < rcs.length()) {
            this.checkCharacter(rcs, i);
            ++seeks;
            for (int j = i - 1; j < i; ++j) {
                this.checkCharacter(rcs, j);
                ++seeks;
            }
            ++i;
        }
        logger.fine(rcs + " seeks count " + seeks + " in " + (new Date().getTime() - timestamp) + " milliseconds.");
    }

    private void checkCharacter(CharSequence rcs, int i) {
        char c = rcs.charAt(i);
        ReplayCharSequenceTest.assertTrue((String)("Character " + Integer.toString(c) + " at offset " + i + " unexpected."), (c % 127 == i % 127 ? 1 : 0) != 0);
    }

    private RecordingOutputStream writeTestStream(byte[] content, int memReps, String baseName, int fileReps) throws IOException {
        String backingFilename = FileUtils.maybeRelative(this.getTmpDir(), baseName).getAbsolutePath();
        RecordingOutputStream ros = new RecordingOutputStream(content.length * memReps, backingFilename);
        ros.open();
        for (int i = 0; i < memReps + fileReps; ++i) {
            ros.write(content);
        }
        ros.close();
        return ros;
    }

    private byte[] fillBufferWithRegularContent(byte[] buffer) {
        int index = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(index & 0xFF);
            if (++index < 127) continue;
            index = 0;
        }
        return buffer;
    }

    public void testCheckParameters() {
    }
}

