/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.archive.io.BufferedSeekInputStream;
import org.archive.io.RandomAccessInputStream;
import org.archive.io.SeekInputStream;

public class ReplayInputStream
extends SeekInputStream {
    private BufferedSeekInputStream diskStream;
    private byte[] buffer;
    private long position;
    private long size = -1L;
    protected long responseBodyStart = -1L;

    public ReplayInputStream(byte[] buffer, long size, long responseBodyStart, String backingFilename) throws IOException {
        this(buffer, size, backingFilename);
        this.responseBodyStart = responseBodyStart;
    }

    public ReplayInputStream(byte[] buffer, long size, String backingFilename) throws IOException {
        this.buffer = buffer;
        this.size = size;
        if (size > (long)buffer.length) {
            RandomAccessInputStream rais = new RandomAccessInputStream(new File(backingFilename));
            this.diskStream = new BufferedSeekInputStream(rais, 4096);
        }
    }

    public long setToResponseBodyStart() throws IOException {
        this.position(this.responseBodyStart);
        return this.position;
    }

    public int read() throws IOException {
        if (this.position == this.size) {
            return -1;
        }
        if (this.position < (long)this.buffer.length) {
            int c = this.buffer[(int)this.position] & 0xFF;
            ++this.position;
            return c;
        }
        int c = this.diskStream.read();
        if (c >= 0) {
            ++this.position;
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position == this.size) {
            return -1;
        }
        if (this.position < (long)this.buffer.length) {
            int toCopy = (int)Math.min(this.size - this.position, Math.min((long)len, (long)this.buffer.length - this.position));
            System.arraycopy(this.buffer, (int)this.position, b, off, toCopy);
            if (toCopy > 0) {
                this.position += (long)toCopy;
            }
            return toCopy;
        }
        int read = this.diskStream.read(b, off, len);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public void readFullyTo(OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int c = this.read(buf);
        while (c != -1) {
            os.write(buf, 0, c);
            c = this.read(buf);
        }
    }

    public void readHeaderTo(OutputStream os) throws IOException {
        this.position = 0L;
        byte[] buf = new byte[(int)this.responseBodyStart];
        int c = this.read(buf, 0, buf.length);
        if (c != -1) {
            os.write(buf, 0, c);
        }
    }

    public void readContentTo(OutputStream os) throws IOException {
        this.setToResponseBodyStart();
        byte[] buf = new byte[4096];
        int c = this.read(buf);
        while (c != -1) {
            os.write(buf, 0, c);
            c = this.read(buf);
        }
    }

    public void readContentTo(OutputStream os, int maxSize) throws IOException {
        this.setToResponseBodyStart();
        byte[] buf = new byte[4096];
        int c = this.read(buf);
        for (int tot = 0; c != -1 && tot < maxSize; tot += c) {
            os.write(buf, 0, c);
            c = this.read(buf);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.diskStream != null) {
            this.diskStream.close();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getHeaderSize() {
        return this.responseBodyStart;
    }

    public long getContentSize() {
        return this.size - this.responseBodyStart;
    }

    public long remaining() {
        return this.size - this.position;
    }

    public void position(long p) throws IOException {
        if (p < 0L) {
            throw new IOException("Negative seek offset.");
        }
        if (p > this.size) {
            throw new IOException("Desired position exceeds size.");
        }
        if (p < (long)this.buffer.length) {
            if (this.position > (long)this.buffer.length) {
                this.diskStream.position(0L);
            }
        } else {
            this.diskStream.position(p - (long)this.buffer.length);
        }
        this.position = p;
    }

    public long position() throws IOException {
        return this.position;
    }
}

