/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.archive.io.SinkHandlerLogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkHandler
extends Handler {
    private Vector<SinkHandlerLogRecord> sink = new Vector();

    public SinkHandler() {
        LogManager manager = LogManager.getLogManager();
        String className = this.getClass().getName();
        String tmp = manager.getProperty(className + ".level");
        if (tmp != null) {
            this.setLevel(Level.parse(tmp));
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.sink.add(new SinkHandlerLogRecord(record));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    public static SinkHandler getInstance() {
        SinkHandler h = null;
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof SinkHandler)) continue;
            h = (SinkHandler)handlers[i];
            break;
        }
        if (h == null) {
            h = new SinkHandler();
            h.setLevel(Level.WARNING);
            Logger.getLogger("").addHandler(h);
        }
        return h;
    }

    public Vector getAll() {
        return this.sink;
    }

    public Vector<SinkHandlerLogRecord> getAllUnread() {
        if (this.sink == null) {
            return null;
        }
        Vector<SinkHandlerLogRecord> newLogRecords = new Vector<SinkHandlerLogRecord>();
        for (SinkHandlerLogRecord lr : this.sink) {
            if (lr.isRead()) continue;
            newLogRecords.add(lr);
        }
        return newLogRecords.size() == 0 ? null : newLogRecords;
    }

    public int getCount() {
        return this.sink != null ? this.sink.size() : 0;
    }

    public int getUnreadCount() {
        if (this.sink == null) {
            return 0;
        }
        int n = 0;
        for (SinkHandlerLogRecord lr : this.sink) {
            if (lr.isRead()) continue;
            ++n;
        }
        return n;
    }

    public SinkHandlerLogRecord get(long id) {
        if (this.sink == null) {
            return null;
        }
        for (SinkHandlerLogRecord lr : this.sink) {
            if (lr.getSequenceNumber() != id) continue;
            return lr;
        }
        return null;
    }

    public SinkHandlerLogRecord remove(long id) {
        SinkHandlerLogRecord shlr = null;
        if (this.sink == null) {
            return shlr;
        }
        Iterator<SinkHandlerLogRecord> i = this.sink.iterator();
        while (i.hasNext()) {
            SinkHandlerLogRecord lr = i.next();
            if (lr.getSequenceNumber() != id) continue;
            i.remove();
            shlr = lr;
            break;
        }
        return shlr;
    }

    public void read(long id) {
        for (SinkHandlerLogRecord lr : this.sink) {
            if (lr.getSequenceNumber() != id) continue;
            lr.setRead();
            break;
        }
    }
}

