/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.archive.io.SinkHandlerLogThread;

public class SinkHandlerLogRecord
extends LogRecord {
    private static final long serialVersionUID = -7782942650334713560L;
    boolean read = false;
    private final LogRecord delegatee;
    private final Date creationTime = new Date();
    private static final int SHORT_MSG_LENGTH = 80;

    protected SinkHandlerLogRecord() {
        this(null);
    }

    public SinkHandlerLogRecord(LogRecord record) {
        super(record.getLevel(), record.getMessage());
        if (Thread.currentThread() instanceof SinkHandlerLogThread) {
            String newMessage = this.getMessage();
            SinkHandlerLogThread tt = (SinkHandlerLogThread)((Object)Thread.currentThread());
            newMessage = newMessage + " (in thread '" + tt.getName() + "'";
            if (tt.getCurrentProcessorName().length() > 0) {
                newMessage = newMessage + "; in processor '" + tt.getCurrentProcessorName() + "'";
            }
            newMessage = newMessage + ")";
            this.setMessage(newMessage);
        }
        this.delegatee = record;
    }

    public boolean equals(long id) {
        return id == this.getSequenceNumber();
    }

    public boolean equals(SinkHandlerLogRecord compare) {
        return this.equals(compare.getSequenceNumber());
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead() {
        this.read = true;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Level getLevel() {
        return this.delegatee.getLevel();
    }

    public String getLoggerName() {
        return this.delegatee.getLoggerName();
    }

    public String getShortMessage() {
        String msg = this.getMessage();
        return msg == null || msg.length() < 80 ? msg : msg.substring(0, 80) + "...";
    }

    public Throwable getThrown() {
        return this.delegatee.getThrown();
    }

    public String getThrownToString() {
        StringWriter sw = new StringWriter();
        Throwable t = this.getThrown();
        if (t == null) {
            sw.write("No associated exception.");
        } else {
            String tStr = t.toString();
            sw.write(tStr);
            if (t.getMessage() != null && t.getMessage().length() > 0 && !tStr.endsWith(t.getMessage())) {
                sw.write("\nMessage: ");
                sw.write(t.getMessage());
            }
            if (t.getCause() != null) {
                sw.write("\nCause: ");
                t.getCause().printStackTrace(new PrintWriter(sw));
            }
            sw.write("\nStacktrace: ");
            t.printStackTrace(new PrintWriter(sw));
        }
        return sw.toString();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write(this.getLevel().toString());
        sw.write(" ");
        sw.write(this.getMessage());
        sw.write(this.getThrownToString());
        return sw.toString();
    }
}

