/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.FairGenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.archive.io.WriterPoolMember;
import org.archive.io.WriterPoolSettings;

public abstract class WriterPool {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    private final AtomicInteger serialNo;
    protected static final int NO_MAX_IDLE = -1;
    private final int arbitraryRetryMax = 10;
    public static final int DEFAULT_MAX_ACTIVE = 5;
    public static final int DEFAULT_MAXIMUM_WAIT = 300000;
    private GenericObjectPool pool = null;
    private final WriterPoolSettings settings;

    private WriterPool() {
        this(null, null, null, -1, -1);
    }

    public WriterPool(AtomicInteger serial, BasePoolableObjectFactory factory, WriterPoolSettings settings, int poolMaximumActive, int poolMaximumWait) {
        this.logger.info("Initial configuration: prefix=" + settings.getPrefix() + ", suffix=" + settings.getSuffix() + ", compress=" + settings.isCompressed() + ", maxSize=" + settings.getMaxSize() + ", maxActive=" + poolMaximumActive + ", maxWait=" + poolMaximumWait);
        this.settings = settings;
        this.pool = new FairGenericObjectPool((PoolableObjectFactory)factory, poolMaximumActive, 1, poolMaximumWait, -1);
        this.serialNo = serial;
    }

    public WriterPoolMember borrowFile() throws IOException {
        WriterPoolMember f = null;
        int i = 0;
        while (f == null) {
            long waitStart = System.currentTimeMillis();
            try {
                f = (WriterPoolMember)this.pool.borrowObject();
                if (this.logger.getLevel() == Level.FINE) {
                    this.logger.fine("Borrowed " + f + " (Pool State: " + this.getPoolState(waitStart) + ").");
                }
            }
            catch (NoSuchElementException e) {
                this.logger.warning(e.getMessage() + ": Retry #" + i + " of " + " max of " + 10 + ": NSEE Pool State: " + this.getPoolState(waitStart));
                if (i >= 10) {
                    this.logger.log(Level.SEVERE, "maximum retries exceeded; rethrowing", e);
                    throw e;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "E Pool State: " + this.getPoolState(waitStart), e);
                throw new IOException("Failed getting writer from pool: " + e.getMessage());
            }
            ++i;
        }
        return f;
    }

    public void returnFile(WriterPoolMember writer) throws IOException {
        try {
            if (this.logger.getLevel() == Level.FINE) {
                this.logger.fine("Returned " + writer);
            }
            this.pool.returnObject(writer);
        }
        catch (Exception e) {
            throw new IOException("Failed restoring writer to pool: " + e.getMessage());
        }
    }

    public void invalidateFile(WriterPoolMember f) throws IOException {
        try {
            this.pool.invalidateObject(f);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        File file = f.getFile();
        file.renameTo(new File(file.getAbsoluteFile() + ".invalid"));
    }

    public int getNumActive() throws UnsupportedOperationException {
        return this.pool.getNumActive();
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return this.pool.getNumIdle();
    }

    public void close() {
        this.pool.clear();
    }

    public WriterPoolSettings getSettings() {
        return this.settings;
    }

    protected String getPoolState() {
        return this.getPoolState(-1L);
    }

    protected String getPoolState(long startTime) {
        StringBuffer buffer = new StringBuffer("Active ");
        buffer.append(this.getNumActive());
        buffer.append(" of max ");
        buffer.append(this.pool.getMaxActive());
        buffer.append(", idle ");
        buffer.append(this.pool.getNumIdle());
        if (startTime != -1L) {
            buffer.append(", time ");
            buffer.append(System.currentTimeMillis() - startTime);
            buffer.append("ms of max ");
            buffer.append(this.pool.getMaxWait());
            buffer.append("ms");
        }
        return buffer.toString();
    }

    public AtomicInteger getSerialNo() {
        return this.serialNo;
    }
}

