/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.archive.io.ArchiveFileConstants;
import org.archive.util.ArchiveUtils;
import org.archive.util.IoUtils;
import org.archive.util.TimestampSerialno;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WriterPoolMember
implements ArchiveFileConstants {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String UTF8 = "UTF-8";
    public static final String DEFAULT_PREFIX = "IAH";
    public static final String HOSTNAME_VARIABLE = "${HOSTNAME}";
    public static final String DEFAULT_SUFFIX = "${HOSTNAME}";
    private File f = null;
    private OutputStream out = null;
    private FileOutputStream fos;
    private final boolean compressed;
    private List<File> writeDirs = null;
    private String prefix = "IAH";
    private String suffix = "${HOSTNAME}";
    private final long maxSize;
    private final String extension;
    private String createTimestamp = "UNSET!!!";
    private final AtomicInteger serialNo;
    private static int roundRobinIndex = 0;
    private static NumberFormat serialNoFormatter = new DecimalFormat("00000");
    private final byte[] scratchbuffer = new byte[4096];

    protected WriterPoolMember(AtomicInteger serialNo, OutputStream out, File file, boolean cmprs, String a14DigitDate) throws IOException {
        this(serialNo, null, null, cmprs, -1L, null);
        this.out = out;
        this.f = file;
    }

    public WriterPoolMember(AtomicInteger serialNo, List<File> dirs, String prefix, boolean cmprs, long maxSize, String extension) {
        this(serialNo, dirs, prefix, "", cmprs, maxSize, extension);
    }

    public WriterPoolMember(AtomicInteger serialNo, List<File> dirs, String prefix, String suffix, boolean cmprs, long maxSize, String extension) {
        this.suffix = suffix;
        this.prefix = prefix;
        this.maxSize = maxSize;
        this.writeDirs = dirs;
        this.compressed = cmprs;
        this.extension = extension;
        this.serialNo = serialNo;
    }

    public void checkSize() throws IOException {
        if (this.out == null || this.maxSize != -1L && this.f.length() > this.maxSize) {
            this.createFile();
        }
    }

    protected String createFile() throws IOException {
        TimestampSerialno tsn = this.getTimestampSerialNo();
        String name = this.prefix + '-' + this.getUniqueBasename(tsn) + (this.suffix == null || this.suffix.length() <= 0 ? "" : "-" + this.suffix) + '.' + this.extension + (this.compressed ? ".gz" : "") + ".open";
        this.createTimestamp = tsn.getTimestamp();
        File dir = this.getNextDirectory(this.writeDirs);
        return this.createFile(new File(dir, name));
    }

    protected String createFile(File file) throws IOException {
        this.close();
        this.f = file;
        this.fos = new FileOutputStream(this.f);
        this.out = new FastBufferedOutputStream((OutputStream)this.fos);
        this.logger.info("Opened " + this.f.getAbsolutePath());
        return this.f.getName();
    }

    protected File getNextDirectory(List<File> dirs) throws IOException {
        if (roundRobinIndex >= dirs.size()) {
            roundRobinIndex = 0;
        }
        File d = null;
        try {
            d = this.checkWriteable(dirs.get(roundRobinIndex));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (d == null && dirs.size() > 1) {
            Iterator<File> i = dirs.iterator();
            while (d == null && i.hasNext()) {
                d = this.checkWriteable(i.next());
            }
        } else {
            ++roundRobinIndex;
        }
        if (d == null) {
            throw new IOException("Directories unusable.");
        }
        return d;
    }

    protected File checkWriteable(File d) {
        if (d == null) {
            return d;
        }
        try {
            IoUtils.ensureWriteableDirectory(d);
        }
        catch (IOException e) {
            this.logger.warning("Directory " + d.getPath() + " is not" + " writeable or cannot be created: " + e.getMessage());
            d = null;
        }
        return d;
    }

    protected synchronized TimestampSerialno getTimestampSerialNo() {
        return this.getTimestampSerialNo(null);
    }

    protected synchronized TimestampSerialno getTimestampSerialNo(String timestamp) {
        return new TimestampSerialno(timestamp != null ? timestamp : ArchiveUtils.get14DigitDate(), this.serialNo.getAndIncrement());
    }

    private String getUniqueBasename(TimestampSerialno tsn) {
        return tsn.getTimestamp() + "-" + serialNoFormatter.format(tsn.getSerialNumber());
    }

    protected String getBaseFilename() {
        String name = this.f.getName();
        if (this.compressed && name.endsWith(".gz")) {
            return name.substring(0, name.length() - 3);
        }
        if (this.compressed && name.endsWith(".gz.open")) {
            return name.substring(0, name.length() - (3 + ".open".length()));
        }
        return name;
    }

    public File getFile() {
        return this.f;
    }

    protected void preWriteRecordTasks() throws IOException {
        this.checkSize();
        if (this.compressed) {
            this.out = new CompressedStream(this.out);
        }
    }

    protected void postWriteRecordTasks() throws IOException {
        if (this.compressed) {
            CompressedStream o = (CompressedStream)this.out;
            o.finish();
            o.flush();
            o.end();
            this.out = o.getWrappedStream();
        }
    }

    public long getPosition() throws IOException {
        long position = 0L;
        if (this.out != null) {
            this.out.flush();
        }
        if (this.fos != null) {
            this.fos.flush();
            position = this.fos.getChannel().position();
        }
        return position;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    protected void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    protected void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    protected void write(int b) throws IOException {
        this.out.write(b);
    }

    protected void readFullyFrom(InputStream is, long recordLength, byte[] b) throws IOException {
        this.copyFrom(is, recordLength, true);
    }

    protected void readToLimitFrom(InputStream is, long limit, byte[] b) throws IOException {
        this.copyFrom(is, limit, true);
    }

    protected void copyFrom(InputStream is, long recordLength, boolean enforceLength) throws IOException {
        long tot;
        int read = this.scratchbuffer.length;
        for (tot = 0L; tot < recordLength && (read = is.read(this.scratchbuffer)) != -1; tot += (long)read) {
            int write = read;
            write = (int)Math.min((long)write, recordLength - tot);
            this.write(this.scratchbuffer, 0, write);
        }
        if (enforceLength && tot != recordLength) {
            throw new IOException("Read " + tot + " but expected " + recordLength);
        }
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        this.fos = null;
        if (this.f != null && this.f.exists()) {
            String path = this.f.getAbsolutePath();
            if (path.endsWith(".open")) {
                File f = new File(path.substring(0, path.length() - ".open".length()));
                if (!this.f.renameTo(f)) {
                    this.logger.warning("Failed rename of " + path);
                }
                this.f = f;
            }
            this.logger.info("Closed " + this.f.getAbsolutePath() + ", size " + this.f.length());
        }
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    protected String getCreateTimestamp() {
        return this.createTimestamp;
    }

    private class CompressedStream
    extends GZIPOutputStream {
        public CompressedStream(OutputStream out) throws IOException {
            super(out);
        }

        OutputStream getWrappedStream() {
            return this.out;
        }

        public void end() {
            this.def.end();
        }
    }
}

