/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.RecoverableIOException;
import org.archive.io.arc.ARCConstants;
import org.archive.io.arc.ARCReaderFactory;
import org.archive.io.arc.ARCRecord;
import org.archive.io.arc.ARCRecordMetaData;
import org.archive.io.arc.ARCWriter;
import org.archive.util.ArchiveUtils;

public abstract class ARCReader
extends ArchiveReader
implements ARCConstants {
    Logger logger = Logger.getLogger(ARCReader.class.getName());
    private boolean alignedOnFirstRecord = true;
    private boolean parseHttpHeaders = true;

    ARCReader() {
    }

    protected void gotoEOR(ArchiveRecord record) throws IOException {
        if (this.getIn().available() <= 0) {
            return;
        }
        int c = -1;
        while (this.getIn().available() > 0) {
            if (this.getIn().markSupported()) {
                this.getIn().mark(1);
            }
            if ((c = this.getIn().read()) == -1 || c == 10) continue;
            if (this.getIn().markSupported()) {
                this.getIn().reset();
                break;
            }
            ArchiveRecordHeader h = this.getCurrentRecord() != null ? record.getHeader() : null;
            throw new IOException("Read " + (char)c + " when only " + '\n' + " expected. " + this.getReaderIdentifier() + (h != null ? h.getHeaderFields().toString() : ""));
        }
    }

    protected ARCRecord createArchiveRecord(InputStream is, long offset) throws IOException {
        try {
            String version = super.getVersion();
            ARCRecord record = new ARCRecord(is, this.getReaderIdentifier(), offset, this.isDigest(), this.isStrict(), this.isParseHttpHeaders(), this.isAlignedOnFirstRecord(), version);
            if (version != null && super.getVersion() == null) {
                super.setVersion(version);
            }
            this.currentRecord(record);
        }
        catch (IOException e) {
            if (e instanceof RecoverableIOException) {
                throw e;
            }
            IOException newE = new IOException(e.getMessage() + " (Offset " + offset + ").");
            newE.setStackTrace(e.getStackTrace());
            throw newE;
        }
        return (ARCRecord)this.getCurrentRecord();
    }

    public String getVersion() {
        return super.getVersion() == null ? "1.1" : super.getVersion();
    }

    protected boolean isAlignedOnFirstRecord() {
        return this.alignedOnFirstRecord;
    }

    protected void setAlignedOnFirstRecord(boolean alignedOnFirstRecord) {
        this.alignedOnFirstRecord = alignedOnFirstRecord;
    }

    public boolean isParseHttpHeaders() {
        return this.parseHttpHeaders;
    }

    public void setParseHttpHeaders(boolean parse) {
        this.parseHttpHeaders = parse;
    }

    public String getFileExtension() {
        return "arc";
    }

    public String getDotFileExtension() {
        return ".arc";
    }

    protected boolean output(String format) throws IOException, java.text.ParseException {
        boolean result = super.output(format);
        if (!result && (format.equals("nohead") || format.equals("header"))) {
            throw new IOException(format + " format only supported for single Records");
        }
        return result;
    }

    public boolean outputRecord(String format) throws IOException {
        boolean result = super.outputRecord(format);
        if (result) {
            return result;
        }
        if (format.equals("nohead")) {
            this.setDigest(false);
            ARCRecord r = (ARCRecord)this.get();
            r.skipHttpHeader();
            r.dump();
            result = true;
        } else if (format.equals("header")) {
            this.setDigest(false);
            ARCRecord r = (ARCRecord)this.get();
            r.dumpHttpHeader();
            result = true;
        }
        return result;
    }

    public void dump(boolean compress) throws IOException, java.text.ParseException {
        this.setDigest(false);
        boolean firstRecord = true;
        ARCWriter writer = null;
        for (ARCRecord r : this) {
            ARCRecordMetaData meta = r.getMetaData();
            if (firstRecord) {
                firstRecord = false;
                ByteArrayOutputStream baos = new ByteArrayOutputStream(r.available());
                while (r.available() > 0) {
                    baos.write(r.read());
                }
                ArrayList<String> listOfMetadata = new ArrayList<String>();
                listOfMetadata.add(baos.toString("UTF-8"));
                writer = new ARCWriter(new AtomicInteger(), System.out, new File(meta.getArc()), compress, meta.getDate(), listOfMetadata);
                continue;
            }
            writer.write(meta.getUrl(), meta.getMimetype(), meta.getIp(), ArchiveUtils.parse14DigitDate(meta.getDate()).getTime(), (long)((int)meta.getLength()), r);
        }
    }

    public ARCReader getDeleteFileOnCloseReader(final File f) {
        final ARCReader d = this;
        return new ARCReader(){
            private final ARCReader delegate;
            private File archiveFile;
            {
                this.delegate = d;
                this.archiveFile = f;
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
                if (this.archiveFile != null) {
                    if (this.archiveFile.exists()) {
                        this.archiveFile.delete();
                    }
                    this.archiveFile = null;
                }
            }

            @Override
            public ArchiveRecord get(long o) throws IOException {
                return this.delegate.get(o);
            }

            @Override
            public boolean isDigest() {
                return this.delegate.isDigest();
            }

            @Override
            public boolean isStrict() {
                return this.delegate.isStrict();
            }

            @Override
            public Iterator<ArchiveRecord> iterator() {
                return this.delegate.iterator();
            }

            @Override
            public void setDigest(boolean d2) {
                this.delegate.setDigest(d2);
            }

            @Override
            public void setStrict(boolean s) {
                this.delegate.setStrict(s);
            }

            public List validate() throws IOException {
                return this.delegate.validate();
            }

            @Override
            public ArchiveRecord get() throws IOException {
                return this.delegate.get();
            }

            @Override
            public String getVersion() {
                return this.delegate.getVersion();
            }

            public List validate(int noRecords) throws IOException {
                return this.delegate.validate(noRecords);
            }

            @Override
            protected ARCRecord createArchiveRecord(InputStream is, long offset) throws IOException {
                return this.delegate.createArchiveRecord(is, offset);
            }

            @Override
            protected void gotoEOR(ArchiveRecord record) throws IOException {
                this.delegate.gotoEOR(record);
            }

            @Override
            public void dump(boolean compress) throws IOException, java.text.ParseException {
                this.delegate.dump(compress);
            }

            @Override
            public String getDotFileExtension() {
                return this.delegate.getDotFileExtension();
            }

            @Override
            public String getFileExtension() {
                return this.delegate.getFileExtension();
            }
        };
    }

    private static void usage(HelpFormatter formatter, Options options, int exitCode) {
        formatter.printHelp("java org.archive.io.arc.ARCReader [--digest=true|false] \\\n [--format=cdx|cdxfile|dump|gzipdump|header|nohead] [--offset=#] \\\n[--strict] [--parse] ARC_FILE|ARC_URL", options);
        System.exit(exitCode);
    }

    protected static void output(ARCReader reader, String format) throws IOException, java.text.ParseException {
        if (!reader.output(format)) {
            throw new IOException("Unsupported format: " + format);
        }
    }

    public static void createCDXIndexFile(String urlOrPath) throws IOException, java.text.ParseException {
        ARCReader r = ARCReaderFactory.get(urlOrPath);
        r.setStrict(false);
        r.setParseHttpHeaders(true);
        r.setDigest(true);
        ARCReader.output(r, "cdxfile");
    }

    public static void main(String[] args) throws ParseException, IOException, java.text.ParseException {
        Options options = ARCReader.getOptions();
        options.addOption(new Option("p", "parse", false, "Parse headers."));
        PosixParser parser = new PosixParser();
        CommandLine cmdline = parser.parse(options, args, false);
        List cmdlineArgs = cmdline.getArgList();
        Option[] cmdlineOptions = cmdline.getOptions();
        HelpFormatter formatter = new HelpFormatter();
        if (cmdlineArgs.size() <= 0) {
            ARCReader.usage(formatter, options, 0);
        }
        long offset = -1L;
        boolean digest = false;
        boolean strict = false;
        boolean parse = false;
        String format = "cdx";
        block10: for (int i = 0; i < cmdlineOptions.length; ++i) {
            switch (cmdlineOptions[i].getId()) {
                case 104: {
                    ARCReader.usage(formatter, options, 0);
                    continue block10;
                }
                case 111: {
                    offset = Long.parseLong(cmdlineOptions[i].getValue());
                    continue block10;
                }
                case 115: {
                    strict = true;
                    continue block10;
                }
                case 112: {
                    parse = true;
                    continue block10;
                }
                case 100: {
                    digest = ARCReader.getTrueOrFalse(cmdlineOptions[i].getValue());
                    continue block10;
                }
                case 102: {
                    format = cmdlineOptions[i].getValue().toLowerCase();
                    boolean match = false;
                    String[] supportedFormats = new String[]{"cdx", "dump", "gzipdump", "header", "nohead", "cdxfile"};
                    for (int ii = 0; ii < supportedFormats.length; ++ii) {
                        if (!supportedFormats[ii].equals(format)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue block10;
                    ARCReader.usage(formatter, options, 1);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unexpected option: " + cmdlineOptions[i].getId());
                }
            }
        }
        if (offset >= 0L) {
            if (cmdlineArgs.size() != 1) {
                System.out.println("Error: Pass one arcfile only.");
                ARCReader.usage(formatter, options, 1);
            }
            ARCReader arc = ARCReaderFactory.get((String)cmdlineArgs.get(0), offset);
            arc.setStrict(strict);
            if (format.equals("nohead") || format.equals("header")) {
                parse = true;
            }
            arc.setParseHttpHeaders(parse);
            ARCReader.outputRecord(arc, format);
        } else {
            for (String urlOrPath : cmdlineArgs) {
                try {
                    ARCReader r = ARCReaderFactory.get(urlOrPath);
                    r.setStrict(strict);
                    r.setParseHttpHeaders(parse);
                    r.setDigest(digest);
                    ARCReader.output(r, format);
                }
                catch (RuntimeException e) {
                    System.err.println("Exception processing " + urlOrPath + ": " + e.getMessage());
                    e.printStackTrace(System.err);
                    System.exit(1);
                }
            }
        }
    }
}

