/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveReaderFactory;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.GzipHeader;
import org.archive.io.GzippedInputStream;
import org.archive.io.NoGzipMagicException;
import org.archive.io.arc.ARCConstants;
import org.archive.io.arc.ARCReader;
import org.archive.io.arc.ARCRecord;
import org.archive.util.FileUtils;

public class ARCReaderFactory
extends ArchiveReaderFactory
implements ARCConstants {
    private static final ARCReaderFactory factory = new ARCReaderFactory();

    protected ARCReaderFactory() {
    }

    public static ARCReader get(String arcFileOrUrl) throws MalformedURLException, IOException {
        return (ARCReader)factory.getArchiveReader(arcFileOrUrl);
    }

    public static ARCReader get(String arcFileOrUrl, long offset) throws MalformedURLException, IOException {
        return (ARCReader)factory.getArchiveReader(arcFileOrUrl, offset);
    }

    public static ARCReader get(File f) throws IOException {
        return (ARCReader)factory.getArchiveReader(f);
    }

    public static ARCReader get(File f, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(f, offset);
    }

    protected ArchiveReader getArchiveReader(File f, long offset) throws IOException {
        return this.getArchiveReader(f, true, offset);
    }

    public static ARCReader get(File f, boolean skipSuffixTest, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(f, skipSuffixTest, offset);
    }

    protected ArchiveReader getArchiveReader(File arcFile, boolean skipSuffixTest, long offset) throws IOException {
        ARCReader aRCReader;
        boolean compressed = ARCReaderFactory.testCompressedARCFile(arcFile, skipSuffixTest);
        if (!compressed && !FileUtils.isReadableWithExtensionAndMagic(arcFile, "arc", "filedesc://")) {
            throw new IOException(arcFile.getAbsolutePath() + " is not an Internet Archive ARC file.");
        }
        if (compressed) {
            ARCReaderFactory aRCReaderFactory = factory;
            aRCReaderFactory.getClass();
            aRCReader = aRCReaderFactory.new CompressedARCReader(arcFile, offset);
        } else {
            ARCReaderFactory aRCReaderFactory = factory;
            aRCReaderFactory.getClass();
            aRCReader = aRCReaderFactory.new UncompressedARCReader(arcFile, offset);
        }
        return aRCReader;
    }

    public static ArchiveReader get(String s, InputStream is, boolean atFirstRecord) throws IOException {
        return factory.getArchiveReader(s, is, atFirstRecord);
    }

    protected ArchiveReader getArchiveReader(String arc, InputStream is, boolean atFirstRecord) throws IOException {
        return new CompressedARCReader(arc, this.asRepositionable(is), atFirstRecord);
    }

    public static ARCReader get(URL arcUrl, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(arcUrl, offset);
    }

    public static ARCReader get(URL arcUrl) throws IOException {
        return (ARCReader)factory.getArchiveReader(arcUrl);
    }

    public boolean isCompressed(File arcFile) throws IOException {
        return ARCReaderFactory.testCompressedARCFile(arcFile);
    }

    public static boolean testCompressedARCFile(File arcFile) throws IOException {
        return ARCReaderFactory.testCompressedARCFile(arcFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCompressedARCFile(File arcFile, boolean skipSuffixCheck) throws IOException {
        boolean compressedARCFile = false;
        FileUtils.isReadable(arcFile);
        if (!skipSuffixCheck && !arcFile.getName().toLowerCase().endsWith("arc.gz")) {
            return compressedARCFile;
        }
        FileInputStream is = new FileInputStream(arcFile);
        try {
            compressedARCFile = ARCReaderFactory.testCompressedARCStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return compressedARCFile;
    }

    public static boolean isARCSuffix(String arcName) {
        return arcName == null ? false : (arcName.toLowerCase().endsWith(".arc.gz") ? true : arcName.toLowerCase().endsWith(".arc"));
    }

    public static boolean testCompressedARCStream(InputStream is) throws IOException {
        boolean compressedARCFile = false;
        GzipHeader gh = null;
        try {
            gh = new GzipHeader(is);
        }
        catch (NoGzipMagicException e) {
            return compressedARCFile;
        }
        byte[] fextra = gh.getFextra();
        if (fextra != null && ARC_GZIP_EXTRA_FIELD.length - 2 == fextra.length) {
            compressedARCFile = true;
            for (int i = 0; i < fextra.length; ++i) {
                if (fextra[i] == ARC_GZIP_EXTRA_FIELD[i + 2]) continue;
                compressedARCFile = false;
                break;
            }
        }
        return compressedARCFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompressedARCReader
    extends ARCReader {
        public CompressedARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public CompressedARCReader(File f, long offset) throws IOException {
            this.setIn(new GzippedInputStream(this.getInputStream(f, offset)));
            this.setCompressed(offset == 0L);
            this.initialize(f.getAbsolutePath());
        }

        public CompressedARCReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
            this.setIn(new GzippedInputStream(is));
            this.setCompressed(true);
            this.setAlignedOnFirstRecord(atFirstRecord);
            this.initialize(f);
        }

        @Override
        public ARCRecord get(long offset) throws IOException {
            this.cleanupCurrentRecord();
            ((GzippedInputStream)this.getIn()).gzipMemberSeek(offset);
            return this.createArchiveRecord(this.getIn(), offset);
        }

        @Override
        public Iterator<ArchiveRecord> iterator() {
            return new ArchiveReader.ArchiveRecordIterator(){
                private GzippedInputStream gis;
                private Iterator gzipIterator;
                {
                    this.gis = (GzippedInputStream)CompressedARCReader.this.getInputStream();
                    this.gzipIterator = this.gis.iterator();
                }

                protected boolean innerHasNext() {
                    return this.gzipIterator.hasNext();
                }

                protected ArchiveRecord innerNext() throws IOException {
                    long p = this.gis.position();
                    InputStream is = (InputStream)this.gzipIterator.next();
                    return CompressedARCReader.this.createArchiveRecord(is, p);
                }
            };
        }

        @Override
        protected void gotoEOR(ArchiveRecord rec) throws IOException {
            long skipped = ((GzippedInputStream)this.getIn()).gotoEOR(10);
            if (skipped <= 0L) {
                return;
            }
            ArchiveRecordHeader meta = this.getCurrentRecord() != null ? rec.getHeader() : null;
            String message = "Record ENDING at " + ((GzippedInputStream)this.getIn()).position() + " has " + skipped + " trailing byte(s): " + (meta != null ? ((Object)meta).toString() : "");
            if (this.isStrict()) {
                throw new IOException(message);
            }
            this.logStdErr(Level.WARNING, message);
        }
    }

    public class UncompressedARCReader
    extends ARCReader {
        public UncompressedARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public UncompressedARCReader(File f, long offset) throws IOException {
            this.setIn(this.getInputStream(f, offset));
            this.initialize(f.getAbsolutePath());
        }

        public UncompressedARCReader(String f, InputStream is) {
            this.setIn(is);
            this.initialize(f);
        }
    }
}

