/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.RecoverableIOException;
import org.archive.io.arc.ARCConstants;
import org.archive.io.arc.ARCRecordMetaData;
import org.archive.util.InetAddressUtil;
import org.archive.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARCRecord
extends ArchiveRecord
implements ARCConstants {
    private StatusLine httpStatus = null;
    private InputStream httpHeaderStream = null;
    private Header[] httpHeaders = null;
    private final String[] headerFieldNameKeysArray = new String[]{"subject-uri", "ip-address", "creation-date", "content-type", "length"};
    private final List<String> headerFieldNameKeys = Arrays.asList(this.headerFieldNameKeysArray);

    public ARCRecord(InputStream in, ArchiveRecordHeader metaData) throws IOException {
        this(in, metaData, 0, true, false, true);
    }

    public ARCRecord(InputStream in, ArchiveRecordHeader metaData, int bodyOffset, boolean digest, boolean strict, boolean parseHttpHeaders) throws IOException {
        super(in, metaData, bodyOffset, digest, strict);
        if (parseHttpHeaders) {
            this.httpHeaderStream = this.readHttpHeader();
        }
    }

    public ARCRecord(InputStream in, String identifier, long offset, boolean digest, boolean strict, boolean parseHttpHeaders, boolean isAlignedOnFirstRecord, String version) throws IOException {
        super(in, null, 0, digest, strict);
        this.setHeader(this.parseHeaders(in, identifier, offset, strict, isAlignedOnFirstRecord, version));
        if (parseHttpHeaders) {
            this.httpHeaderStream = this.readHttpHeader();
        }
    }

    public ARCRecord(InputStream in, String identifier, long offset, boolean digest, boolean strict, boolean parseHttpHeaders) throws IOException {
        this(in, identifier, offset, digest, strict, parseHttpHeaders, false, null);
    }

    private ArchiveRecordHeader parseHeaders(InputStream in, String identifier, long offset, boolean strict, boolean isAlignedOnFirstRecord, String version) throws IOException {
        ArrayList<String> firstLineValues = new ArrayList<String>(20);
        this.getTokenizedHeaderLine(in, firstLineValues);
        int bodyOffset = 0;
        if (offset == 0L && isAlignedOnFirstRecord) {
            ArrayList<String> secondLineValues = new ArrayList<String>(20);
            bodyOffset += this.getTokenizedHeaderLine(in, secondLineValues);
            version = secondLineValues.get(0) + "." + secondLineValues.get(1);
            bodyOffset += this.getTokenizedHeaderLine(in, null);
        }
        this.setBodyOffset(bodyOffset);
        return this.computeMetaData(this.headerFieldNameKeys, firstLineValues, version, offset, identifier);
    }

    private int getTokenizedHeaderLine(InputStream stream, List<String> list) throws IOException {
        StringBuilder buffer = new StringBuilder(2068);
        int read = 0;
        int previous = -1;
        int c = -1;
        while (true) {
            previous = c;
            c = stream.read();
            if (c == -1) {
                throw new RecoverableIOException("Hit EOF before header EOL.");
            }
            c &= 0xFF;
            if (++read > 102400) {
                throw new IOException("Header line longer than max allowed  -- " + String.valueOf(102400) + " -- or passed buffer doesn't contain a line (Read: " + buffer.length() + ").  Here's" + " some of what was read: " + buffer.substring(0, Math.min(buffer.length(), 256)));
            }
            if (c == 10) {
                if (buffer.length() == 0) continue;
                if (list == null) break;
                list.add(buffer.toString());
                break;
            }
            if (c == 32) {
                if (!this.isStrict() && previous == 32) continue;
                if (list != null) {
                    list.add(buffer.toString());
                }
                buffer.setLength(0);
                continue;
            }
            buffer.append((char)c);
        }
        if (list != null && (list.size() < 3 || list.size() > 100)) {
            throw new IOException("Unparseable header line: " + list);
        }
        return read;
    }

    private ARCRecordMetaData computeMetaData(List<String> keys, List<String> values, String v, long offset, String identifier) throws IOException {
        if (keys.size() != values.size()) {
            List<String> originalValues = values;
            if (!this.isStrict()) {
                values = this.fixSpaceInURL(values, keys.size());
                if (keys.size() != values.size()) {
                    ArrayList<String> nuvalues;
                    if (values.size() == keys.size() + 1 && values.get(4).toLowerCase().startsWith("charset=")) {
                        nuvalues = new ArrayList<String>(keys.size());
                        nuvalues.add(0, values.get(0));
                        nuvalues.add(1, values.get(1));
                        nuvalues.add(2, values.get(2));
                        nuvalues.add(3, values.get(3) + values.get(4));
                        nuvalues.add(4, values.get(5));
                        values = nuvalues;
                    } else if (values.size() + 1 == keys.size() && this.isLegitimateIPValue(values.get(1)) && this.isDate(values.get(2)) && this.isNumber(values.get(3))) {
                        nuvalues = new ArrayList(keys.size());
                        nuvalues.add(0, values.get(0));
                        nuvalues.add(1, values.get(1));
                        nuvalues.add(2, values.get(2));
                        nuvalues.add(3, "-");
                        nuvalues.add(4, values.get(3));
                        values = nuvalues;
                    }
                }
            }
            if (keys.size() != values.size()) {
                throw new IOException("Size of field name keys does not match count of field values: " + values);
            }
            System.err.println(Level.WARNING.toString() + "Fixed spaces in metadata line at " + "offset " + offset + " Original: " + originalValues + ", New: " + values);
        }
        HashMap<String, Object> headerFields = new HashMap<String, Object>(keys.size() + 2);
        for (int i = 0; i < keys.size(); ++i) {
            headerFields.put(keys.get(i), values.get(i));
        }
        String url = (String)headerFields.get("subject-uri");
        if (url != null && url.indexOf(9) >= 0) {
            headerFields.put("subject-uri", TextUtils.replaceAll("\t", url, "%09"));
        }
        headerFields.put("version", v);
        headerFields.put("absolute-offset", new Long(offset));
        return new ARCRecordMetaData(identifier, headerFields);
    }

    private List<String> fixSpaceInURL(List<String> values, int requiredSize) {
        int i;
        if (values.size() <= requiredSize || values.size() < 4) {
            return values;
        }
        if (!this.isDate(values.get(values.size() - 3))) {
            return values;
        }
        if (!this.isLegitimateIPValue(values.get(values.size() - 4))) {
            return values;
        }
        ArrayList<String> newValues = new ArrayList<String>(requiredSize);
        StringBuffer url = new StringBuffer();
        for (i = 0; i < values.size() - 4; ++i) {
            if (i > 0) {
                url.append("%20");
            }
            url.append(values.get(i));
        }
        newValues.add(url.toString());
        for (i = values.size() - 4; i < values.size(); ++i) {
            newValues.add(values.get(i));
        }
        return newValues;
    }

    private boolean isDate(String date) {
        if (date.length() != 14) {
            return false;
        }
        return this.isNumber(date);
    }

    private boolean isNumber(String n) {
        for (int i = 0; i < n.length(); ++i) {
            if (Character.isDigit(n.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isLegitimateIPValue(String ip) {
        if ("-".equals(ip)) {
            return true;
        }
        Matcher m = InetAddressUtil.IPV4_QUADS.matcher(ip);
        return m != null && m.matches();
    }

    public void skipHttpHeader() throws IOException {
        if (this.httpHeaderStream != null) {
            int available = this.httpHeaderStream.available();
            while (this.httpHeaderStream != null && (available = this.httpHeaderStream.available()) > 0) {
                byte[] buffer = new byte[available];
                this.read(buffer, 0, available);
            }
        }
    }

    public void dumpHttpHeader() throws IOException {
        if (this.httpHeaderStream == null) {
            return;
        }
        int available = this.httpHeaderStream.available();
        while (this.httpHeaderStream != null && (available = this.httpHeaderStream.available()) > 0) {
            byte[] buffer = new byte[available];
            int read = this.read(buffer, 0, available);
            System.out.write(buffer, 0, read);
        }
    }

    private InputStream readHttpHeader() throws IOException {
        String url = this.getHeader().getUrl();
        if (!url.startsWith("http") || this.getHeader().getLength() <= MIN_HTTP_HEADER_LENGTH) {
            return null;
        }
        byte[] statusBytes = HttpParser.readRawLine(this.getIn());
        int eolCharCount = this.getEolCharsCount(statusBytes);
        if (eolCharCount <= 0) {
            throw new RecoverableIOException("Failed to read http status where one was expected: " + (statusBytes == null ? "" : new String(statusBytes)));
        }
        String statusLine = EncodingUtil.getString((byte[])statusBytes, (int)0, (int)(statusBytes.length - eolCharCount), (String)"ISO-8859-1");
        if (statusLine == null || !StatusLine.startsWithHTTP((String)statusLine)) {
            if (statusLine.startsWith("DELETED")) {
                throw new DeletedARCRecordIOException(statusLine);
            }
            throw new RecoverableIOException("Failed parse of http status line.");
        }
        this.httpStatus = new StatusLine(statusLine);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(statusBytes.length + 4096);
        baos.write(statusBytes);
        byte[] lineBytes = null;
        do {
            if ((eolCharCount = this.getEolCharsCount(lineBytes = HttpParser.readRawLine(this.getIn()))) <= 0) {
                throw new IOException("Failed reading http headers: " + (lineBytes != null ? new String(lineBytes) : null));
            }
            baos.write(lineBytes);
        } while (lineBytes.length - eolCharCount > 0);
        byte[] headerBytes = baos.toByteArray();
        this.getMetaData().setContentBegin(headerBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        if (!bais.markSupported()) {
            throw new IOException("ByteArrayInputStream does not support mark");
        }
        bais.mark(headerBytes.length);
        bais.read(statusBytes, 0, statusBytes.length);
        this.httpHeaders = HttpParser.parseHeaders(bais, "ISO-8859-1");
        this.getMetaData().setStatusCode(Integer.toString(this.getStatusCode()));
        bais.reset();
        return bais;
    }

    public int getStatusCode() {
        return this.httpStatus == null ? -1 : this.httpStatus.getStatusCode();
    }

    private int getEolCharsCount(byte[] bytes) {
        int count = 0;
        if (bytes != null && bytes.length >= 1 && bytes[bytes.length - 1] == 10) {
            ++count;
            if (bytes.length >= 2 && bytes[bytes.length - 2] == 13) {
                ++count;
            }
        }
        return count;
    }

    public ARCRecordMetaData getMetaData() {
        return (ARCRecordMetaData)this.getHeader();
    }

    public Header[] getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        if (this.httpHeaderStream != null && this.httpHeaderStream.available() > 0) {
            c = this.httpHeaderStream.read();
            if (this.httpHeaderStream.available() <= 0) {
                this.httpHeaderStream = null;
            }
            this.incrementPosition();
        } else {
            c = super.read();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int read = -1;
        if (this.httpHeaderStream != null && this.httpHeaderStream.available() > 0) {
            read = Math.min(length, this.httpHeaderStream.available());
            read = read == 0 ? -1 : this.httpHeaderStream.read(b, offset, read);
            if (this.httpHeaderStream.available() <= 0) {
                this.httpHeaderStream = null;
            }
            this.incrementPosition(read);
        } else {
            read = super.read(b, offset, length);
        }
        return read;
    }

    public int getBodyOffset() {
        return this.getMetaData().getContentBegin();
    }

    @Override
    protected String getIp4Cdx(ArchiveRecordHeader h) {
        String result = null;
        if (h instanceof ARCRecordMetaData) {
            result = ((ARCRecordMetaData)h).getIp();
        }
        return result != null ? result : super.getIp4Cdx(h);
    }

    @Override
    protected String getStatusCode4Cdx(ArchiveRecordHeader h) {
        String result = null;
        if (h instanceof ARCRecordMetaData) {
            result = ((ARCRecordMetaData)h).getStatusCode();
        }
        return result != null ? result : super.getStatusCode4Cdx(h);
    }

    @Override
    protected String getDigest4Cdx(ArchiveRecordHeader h) {
        String result = null;
        if (h instanceof ARCRecordMetaData) {
            result = ((ARCRecordMetaData)h).getDigest();
        }
        return result != null ? result : super.getDigest4Cdx(h);
    }

    private static class DeletedARCRecordIOException
    extends RecoverableIOException {
        public DeletedARCRecordIOException(String reason) {
            super(reason);
        }
    }
}

