/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.arc.ARCConstants;

public class ARCRecordMetaData
implements ArchiveRecordHeader,
ARCConstants {
    protected Map headerFields = null;
    private String digest = null;
    private String statusCode = null;
    private String arc = null;
    private int contentBegin = 0;

    protected ARCRecordMetaData() {
    }

    public ARCRecordMetaData(String arc, Map headerFields) throws IOException {
        Iterator i = REQUIRED_VERSION_1_HEADER_FIELDS.iterator();
        while (i.hasNext()) {
            this.testRequiredField(headerFields, (String)i.next());
        }
        this.headerFields = headerFields;
        this.arc = arc;
    }

    protected void testRequiredField(Map fields, String requiredField) throws IOException {
        if (!fields.containsKey(requiredField)) {
            throw new IOException("Required field " + requiredField + " not in meta data.");
        }
    }

    public String getDate() {
        return (String)this.headerFields.get("creation-date");
    }

    public long getLength() {
        return Long.parseLong((String)this.headerFields.get("length"));
    }

    public String getUrl() {
        return (String)this.headerFields.get("subject-uri");
    }

    public String getIp() {
        return (String)this.headerFields.get("ip-address");
    }

    public String getMimetype() {
        return (String)this.headerFields.get("content-type");
    }

    public String getVersion() {
        return (String)this.headerFields.get("version");
    }

    public long getOffset() {
        return (Long)this.headerFields.get("absolute-offset");
    }

    public Object getHeaderValue(String key) {
        return this.headerFields.get(key);
    }

    public Set getHeaderFieldKeys() {
        return this.headerFields.keySet();
    }

    public Map getHeaderFields() {
        return this.headerFields;
    }

    public String getArc() {
        return this.arc;
    }

    public File getArcFile() {
        return new File(this.arc);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String d) {
        this.digest = d;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String toString() {
        return (this.arc != null ? this.arc : "") + ": " + (this.headerFields != null ? this.headerFields.toString() : "");
    }

    public String getReaderIdentifier() {
        return this.getArc();
    }

    public String getRecordIdentifier() {
        return this.getDate() + "/" + this.getUrl();
    }

    public int getContentBegin() {
        return this.contentBegin;
    }

    void setContentBegin(int offset) {
        this.contentBegin = offset;
    }
}

