/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.archive.io.GzipHeader;
import org.archive.io.NoGzipMagicException;
import org.archive.io.arc.ARCConstants;
import org.archive.net.UURI;

public class ARCUtils
implements ARCConstants {
    public static String parseArcFilename(String pathOrUri) throws URISyntaxException {
        String path = pathOrUri;
        if (UURI.hasScheme(pathOrUri)) {
            URI url = new URI(pathOrUri);
            path = url.getPath();
        }
        return new File(path).getName();
    }

    public static boolean isCompressed(File arcFile) throws IOException {
        return ARCUtils.testCompressedARCFile(arcFile);
    }

    public static boolean testCompressedARCFile(File arcFile) throws IOException {
        return ARCUtils.testCompressedARCFile(arcFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCompressedARCFile(File arcFile, boolean skipSuffixCheck) throws IOException {
        boolean compressedARCFile = false;
        ARCUtils.isReadable(arcFile);
        if (!skipSuffixCheck && !arcFile.getName().toLowerCase().endsWith("arc.gz")) {
            return compressedARCFile;
        }
        FileInputStream is = new FileInputStream(arcFile);
        try {
            compressedARCFile = ARCUtils.testCompressedARCStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return compressedARCFile;
    }

    public static boolean testCompressedARCStream(InputStream is) throws IOException {
        boolean compressedARCFile = false;
        GzipHeader gh = null;
        try {
            gh = new GzipHeader(is);
        }
        catch (NoGzipMagicException e) {
            return compressedARCFile;
        }
        byte[] fextra = gh.getFextra();
        if (fextra != null && ARC_GZIP_EXTRA_FIELD.length - 2 == fextra.length) {
            compressedARCFile = true;
            for (int i = 0; i < fextra.length; ++i) {
                if (fextra[i] == ARC_GZIP_EXTRA_FIELD[i + 2]) continue;
                compressedARCFile = false;
                break;
            }
        }
        return compressedARCFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCompressedRepositionalStream(RepositionableStream rs) throws IOException {
        boolean compressedARCFile = false;
        long p = rs.position();
        try {
            compressedARCFile = ARCUtils.testCompressedStream((InputStream)rs);
        }
        finally {
            rs.position(p);
        }
        return compressedARCFile;
    }

    public static boolean testCompressedStream(InputStream is) throws IOException {
        boolean compressedARCFile = false;
        try {
            new GzipHeader(is);
            compressedARCFile = true;
        }
        catch (NoGzipMagicException e) {
            return compressedARCFile;
        }
        return compressedARCFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testUncompressedARCFile(File arcFile) throws IOException {
        boolean uncompressedARCFile = false;
        ARCUtils.isReadable(arcFile);
        if (arcFile.getName().toLowerCase().endsWith("arc")) {
            FileInputStream fis = new FileInputStream(arcFile);
            try {
                byte[] b = new byte["filedesc://".length()];
                int read = fis.read(b, 0, "filedesc://".length());
                fis.close();
                if (read == "filedesc://".length()) {
                    StringBuffer beginStr = new StringBuffer("filedesc://".length());
                    for (int i = 0; i < "filedesc://".length(); ++i) {
                        beginStr.append((char)b[i]);
                    }
                    if (beginStr.toString().equalsIgnoreCase("filedesc://")) {
                        uncompressedARCFile = true;
                    }
                }
            }
            finally {
                fis.close();
            }
        }
        return uncompressedARCFile;
    }

    private static void isReadable(File arcFile) throws IOException {
        if (!arcFile.exists()) {
            throw new FileNotFoundException(arcFile.getAbsolutePath() + " does not exist.");
        }
        if (!arcFile.canRead()) {
            throw new FileNotFoundException(arcFile.getAbsolutePath() + " is not readable.");
        }
    }
}

