/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.io.GzippedInputStream;
import org.archive.io.ReplayInputStream;
import org.archive.io.WriterPoolMember;
import org.archive.io.arc.ARCConstants;
import org.archive.util.ArchiveUtils;
import org.archive.util.DevUtils;
import org.archive.util.MimetypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARCWriter
extends WriterPoolMember
implements ARCConstants {
    private static final Logger logger = Logger.getLogger(ARCWriter.class.getName());
    private static final Pattern METADATA_LINE_PATTERN = Pattern.compile("^\\S+ \\S+ \\S+ \\S+ \\S+(\n?)$");
    private List metadata = null;

    public ARCWriter(AtomicInteger serialNo, PrintStream out, File arc, boolean cmprs, String a14DigitDate, List metadata) throws IOException {
        super(serialNo, out, arc, cmprs, a14DigitDate);
        this.metadata = metadata;
        this.writeFirstRecord(a14DigitDate);
    }

    public ARCWriter(AtomicInteger serialNo, List<File> dirs, String prefix, boolean cmprs, long maxSize) {
        this(serialNo, dirs, prefix, "", cmprs, maxSize, (List)null);
    }

    public ARCWriter(AtomicInteger serialNo, List<File> dirs, String prefix, String suffix, boolean cmprs, long maxSize, List meta) {
        super(serialNo, dirs, prefix, suffix, cmprs, maxSize, "arc");
        this.metadata = meta;
    }

    @Override
    protected String createFile() throws IOException {
        String name = super.createFile();
        this.writeFirstRecord(this.getCreateTimestamp());
        return name;
    }

    private void writeFirstRecord(String ts) throws IOException {
        this.write(this.generateARCFileMetaData(ts));
    }

    private byte[] generateARCFileMetaData(String date) throws IOException {
        int metadataBodyLength = this.getMetadataLength();
        String metadataHeaderLinesTwoAndThree = this.getMetadataHeaderLinesTwoAndThree("1 " + (metadataBodyLength > 0 ? "1" : "0"));
        int recordLength = metadataBodyLength + metadataHeaderLinesTwoAndThree.getBytes("ISO-8859-1").length;
        String metadataHeaderStr = "filedesc://" + this.getBaseFilename() + " 0.0.0.0 " + date + " text/plain " + recordLength + metadataHeaderLinesTwoAndThree;
        ByteArrayOutputStream metabaos = new ByteArrayOutputStream(recordLength);
        metabaos.write(metadataHeaderStr.getBytes("ISO-8859-1"));
        if (metadataBodyLength > 0) {
            this.writeMetaData(metabaos);
        }
        metabaos.write(10);
        byte[] bytes = metabaos.toByteArray();
        if (this.isCompressed()) {
            byte[] gzippedMetaData = GzippedInputStream.gzip(bytes);
            if (gzippedMetaData[3] != 0) {
                throw new IOException("The GZIP FLG header is unexpectedly  non-zero.  Need to add smarter code that can deal  when already extant extra GZIP header fields.");
            }
            gzippedMetaData[3] = 4;
            gzippedMetaData[9] = 3;
            byte[] assemblyBuffer = new byte[gzippedMetaData.length + ARC_GZIP_EXTRA_FIELD.length];
            System.arraycopy(gzippedMetaData, 0, assemblyBuffer, 0, 10);
            System.arraycopy(ARC_GZIP_EXTRA_FIELD, 0, assemblyBuffer, 10, ARC_GZIP_EXTRA_FIELD.length);
            System.arraycopy(gzippedMetaData, 10, assemblyBuffer, 10 + ARC_GZIP_EXTRA_FIELD.length, gzippedMetaData.length - 10);
            bytes = assemblyBuffer;
        }
        return bytes;
    }

    public String getMetadataHeaderLinesTwoAndThree(String version) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\n');
        buffer.append(version);
        buffer.append(" InternetArchive");
        buffer.append('\n');
        buffer.append("URL IP-address Archive-date Content-type Archive-length");
        buffer.append('\n');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetaData(ByteArrayOutputStream baos) throws UnsupportedEncodingException, IOException {
        if (this.metadata == null) {
            return;
        }
        for (Object obj : this.metadata) {
            if (obj instanceof String) {
                baos.write(((String)obj).getBytes("ISO-8859-1"));
                continue;
            }
            if (obj instanceof File) {
                InputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream((File)obj));
                    byte[] buffer = new byte[4096];
                    int read = -1;
                    while ((read = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    continue;
                }
            }
            if (obj == null) continue;
            logger.severe("Unsupported metadata type: " + obj);
        }
    }

    private int getMetadataLength() throws UnsupportedEncodingException {
        int result = -1;
        if (this.metadata == null) {
            result = 0;
        } else {
            for (Object obj : this.metadata) {
                if (obj instanceof String) {
                    result += ((String)obj).getBytes("ISO-8859-1").length;
                    continue;
                }
                if (obj instanceof File) {
                    result = (int)((long)result + ((File)obj).length());
                    continue;
                }
                logger.severe("Unsupported metadata type: " + obj);
            }
        }
        return result;
    }

    public void write(String uri, String contentType, String hostIP, long fetchBeginTimeStamp, long recordLength, ByteArrayOutputStream baos) throws IOException {
        this.write(uri, contentType, hostIP, fetchBeginTimeStamp, recordLength, new ByteArrayInputStream(baos.toByteArray()), false);
    }

    public void write(String uri, String contentType, String hostIP, long fetchBeginTimeStamp, long recordLength, InputStream in) throws IOException {
        this.write(uri, contentType, hostIP, fetchBeginTimeStamp, recordLength, in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String uri, String contentType, String hostIP, long fetchBeginTimeStamp, long recordLength, InputStream in, boolean enforceLength) throws IOException {
        this.preWriteRecordTasks();
        try {
            long remaining;
            this.write(this.getMetaLine(uri, contentType, hostIP, fetchBeginTimeStamp, recordLength).getBytes("UTF-8"));
            this.copyFrom(in, recordLength, enforceLength);
            if (in instanceof ReplayInputStream && (remaining = ((ReplayInputStream)in).remaining()) != 0L) {
                String message = "Gap between expected and actual: " + remaining + '\n' + DevUtils.extraInfo() + " writing arc " + this.getFile().getAbsolutePath();
                DevUtils.warnHandle(new Throwable(message), message);
                throw new IOException(message);
            }
            this.write(10);
        }
        finally {
            this.postWriteRecordTasks();
        }
    }

    protected String getMetaLine(String uri, String contentType, String hostIP, long fetchBeginTimeStamp, long recordLength) throws IOException {
        if (fetchBeginTimeStamp <= 0L) {
            throw new IOException("Bogus fetchBeginTimestamp: " + Long.toString(fetchBeginTimeStamp));
        }
        return this.validateMetaLine(this.createMetaline(uri, hostIP, ArchiveUtils.get14DigitDate(fetchBeginTimeStamp), MimetypeUtils.truncate(contentType), Long.toString(recordLength)));
    }

    public String createMetaline(String uri, String hostIP, String timeStamp, String mimetype, String recordLength) {
        return uri + ' ' + hostIP + ' ' + timeStamp + ' ' + mimetype + ' ' + recordLength + '\n';
    }

    protected String validateMetaLine(String metaLineStr) throws IOException {
        if (metaLineStr.length() > 4096) {
            throw new IOException("Metadata line too long (" + metaLineStr.length() + ">" + 4096 + "): " + metaLineStr);
        }
        Matcher m = METADATA_LINE_PATTERN.matcher(metaLineStr);
        if (!m.matches()) {
            throw new IOException("Metadata line doesn't match expected pattern: " + metaLineStr);
        }
        return metaLineStr;
    }
}

