/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.archive.io.WriterPool;
import org.archive.io.WriterPoolMember;
import org.archive.io.WriterPoolSettings;
import org.archive.io.arc.ARCWriter;

public class ARCWriterPool
extends WriterPool {
    public ARCWriterPool(WriterPoolSettings settings, int poolMaximumActive, int poolMaximumWait) {
        this(new AtomicInteger(), settings, poolMaximumActive, poolMaximumWait);
    }

    public ARCWriterPool(final AtomicInteger serial, final WriterPoolSettings settings, int poolMaximumActive, int poolMaximumWait) {
        super(serial, new BasePoolableObjectFactory(){

            public Object makeObject() throws Exception {
                return new ARCWriter(serial, settings.getOutputDirs(), settings.getPrefix(), settings.getSuffix(), settings.isCompressed(), settings.getMaxSize(), settings.getMetadata());
            }

            public void destroyObject(Object arcWriter) throws Exception {
                ((WriterPoolMember)arcWriter).close();
                super.destroyObject(arcWriter);
            }
        }, settings, poolMaximumActive, poolMaximumWait);
    }
}

