/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveReaderFactory;
import org.archive.io.ArchiveRecord;
import org.archive.io.GzippedInputStream;
import org.archive.io.warc.WARCConstants;
import org.archive.io.warc.WARCReader;
import org.archive.io.warc.WARCRecord;
import org.archive.util.FileUtils;

public class WARCReaderFactory
extends ArchiveReaderFactory
implements WARCConstants {
    private static final WARCReaderFactory factory = new WARCReaderFactory();

    private WARCReaderFactory() {
    }

    public static WARCReader get(String arcFileOrUrl) throws MalformedURLException, IOException {
        return (WARCReader)factory.getArchiveReader(arcFileOrUrl);
    }

    public static WARCReader get(File f) throws IOException {
        return (WARCReader)factory.getArchiveReader(f);
    }

    public static WARCReader get(File f, long offset) throws IOException {
        return (WARCReader)factory.getArchiveReader(f, offset);
    }

    protected ArchiveReader getArchiveReader(File f, long offset) throws IOException {
        WARCReader wARCReader;
        boolean compressed = WARCReaderFactory.testCompressedWARCFile(f);
        if (!compressed && !FileUtils.isReadableWithExtensionAndMagic(f, ".warc", "WARC/")) {
            throw new IOException(f.getAbsolutePath() + " is not a WARC file.");
        }
        if (compressed) {
            WARCReaderFactory wARCReaderFactory = factory;
            wARCReaderFactory.getClass();
            wARCReader = wARCReaderFactory.new CompressedWARCReader(f, offset);
        } else {
            WARCReaderFactory wARCReaderFactory = factory;
            wARCReaderFactory.getClass();
            wARCReader = wARCReaderFactory.new UncompressedWARCReader(f, offset);
        }
        return wARCReader;
    }

    public static ArchiveReader get(String s, InputStream is, boolean atFirstRecord) throws IOException {
        return factory.getArchiveReader(s, is, atFirstRecord);
    }

    protected ArchiveReader getArchiveReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
        return new CompressedWARCReader(f, this.asRepositionable(is), atFirstRecord);
    }

    public static WARCReader get(URL arcUrl, long offset) throws IOException {
        return (WARCReader)factory.getArchiveReader(arcUrl, offset);
    }

    public static WARCReader get(URL arcUrl) throws IOException {
        return (WARCReader)factory.getArchiveReader(arcUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCompressedWARCFile(File f) throws IOException {
        FileUtils.isReadable(f);
        boolean compressed = false;
        FileInputStream is = new FileInputStream(f);
        try {
            compressed = GzippedInputStream.isCompressedStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return compressed;
    }

    public static boolean isWARCSuffix(String f) {
        return f == null ? false : (f.toLowerCase().endsWith(".warc.gz") ? true : f.toLowerCase().endsWith(".warc"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompressedWARCReader
    extends WARCReader {
        public CompressedWARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public CompressedWARCReader(File f, long offset) throws IOException {
            this.setIn(new GzippedInputStream(this.getInputStream(f, offset)));
            this.setCompressed(offset == 0L);
            this.initialize(f.getAbsolutePath());
        }

        public CompressedWARCReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
            this.setIn(new GzippedInputStream(is));
            this.setCompressed(true);
            this.initialize(f);
        }

        @Override
        public WARCRecord get(long offset) throws IOException {
            this.cleanupCurrentRecord();
            ((GzippedInputStream)this.getIn()).gzipMemberSeek(offset);
            return this.createArchiveRecord(this.getIn(), offset);
        }

        @Override
        public Iterator<ArchiveRecord> iterator() {
            return new ArchiveReader.ArchiveRecordIterator(){
                private GzippedInputStream gis;
                private Iterator gzipIterator;
                {
                    this.gis = (GzippedInputStream)CompressedWARCReader.this.getInputStream();
                    this.gzipIterator = this.gis.iterator();
                }

                protected boolean innerHasNext() {
                    return this.gzipIterator.hasNext();
                }

                protected ArchiveRecord innerNext() throws IOException {
                    long p = this.gis.position();
                    InputStream is = (InputStream)this.gzipIterator.next();
                    return CompressedWARCReader.this.createArchiveRecord(is, p);
                }
            };
        }

        @Override
        protected void gotoEOR(ArchiveRecord rec) throws IOException {
        }
    }

    public class UncompressedWARCReader
    extends WARCReader {
        public UncompressedWARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public UncompressedWARCReader(File f, long offset) throws IOException {
            this.setIn(this.getInputStream(f, offset));
            this.initialize(f.getAbsolutePath());
        }

        public UncompressedWARCReader(String f, InputStream is) {
            this.setIn(is);
            this.initialize(f);
        }
    }
}

