/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.archive.io.WriterPoolMember;
import org.archive.io.warc.WARCConstants;
import org.archive.uid.GeneratorFactory;
import org.archive.util.ArchiveUtils;
import org.archive.util.anvl.ANVLRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARCWriter
extends WriterPoolMember
implements WARCConstants {
    public static byte[] CRLF_BYTES;
    private final List fileMetadata;

    WARCWriter() {
        this((AtomicInteger)null, (List<File>)null, "", "", true, -1L, (List)null);
    }

    public WARCWriter(AtomicInteger serialNo, OutputStream out, File f, boolean cmprs, String a14DigitDate, List warcinfoData) throws IOException {
        super(serialNo, out, f, cmprs, a14DigitDate);
        this.fileMetadata = warcinfoData;
    }

    public WARCWriter(AtomicInteger serialNo, List<File> dirs, String prefix, String suffix, boolean cmprs, long maxSize, List warcinfoData) {
        super(serialNo, dirs, prefix, suffix, cmprs, maxSize, "warc");
        this.fileMetadata = warcinfoData;
    }

    @Override
    protected String createFile(File file) throws IOException {
        String filename = super.createFile(file);
        this.writeWarcinfoRecord(filename);
        return filename;
    }

    protected void baseCharacterCheck(char c, String parameter) throws IOException {
        if (Character.isISOControl(c) || !Character.isValidCodePoint(c)) {
            throw new IOException("Contains illegal character 0x" + Integer.toHexString(c) + ": " + parameter);
        }
    }

    protected String checkHeaderValue(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            this.baseCharacterCheck(c, value);
            if (!Character.isWhitespace(c)) continue;
            throw new IOException("Contains disallowed white space 0x" + Integer.toHexString(c) + ": " + value);
        }
        return value;
    }

    protected String checkHeaderLineMimetypeParameter(String parameter) throws IOException {
        StringBuilder sb = new StringBuilder(parameter.length());
        boolean wasWhitespace = false;
        for (int i = 0; i < parameter.length(); ++i) {
            char c = parameter.charAt(i);
            if (Character.isWhitespace(c)) {
                if (wasWhitespace) continue;
                wasWhitespace = true;
                c = ' ';
            } else {
                wasWhitespace = false;
                this.baseCharacterCheck(c, parameter);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String createRecordHeader(String type, String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord xtraHeaders, long contentLength) throws IOException {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("WARC/0.18").append("\r\n");
        sb.append("WARC-Type").append(": ").append(type).append("\r\n");
        if (url != null && url.length() > 0) {
            sb.append("WARC-Target-URI").append(": ").append(this.checkHeaderValue(url)).append("\r\n");
        }
        sb.append("WARC-Date").append(": ").append(create14DigitDate).append("\r\n");
        if (xtraHeaders != null) {
            Iterator i = xtraHeaders.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append("\r\n");
            }
        }
        sb.append("WARC-Record-ID").append(": ").append('<').append(recordId.toString()).append('>').append("\r\n");
        if (contentLength > 0L) {
            sb.append("Content-Type").append(": ").append(this.checkHeaderLineMimetypeParameter(mimetype)).append("\r\n");
        }
        sb.append("Content-Length").append(": ").append(Long.toString(contentLength)).append("\r\n");
        return sb.toString();
    }

    protected void writeRecord(String type, String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord xtraHeaders, InputStream contentStream, long contentLength) throws IOException {
        this.writeRecord(type, url, create14DigitDate, mimetype, recordId, xtraHeaders, contentStream, contentLength, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecord(String type, String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord xtraHeaders, InputStream contentStream, long contentLength, boolean enforceLength) throws IOException {
        if (!TYPES_LIST.contains(type)) {
            throw new IllegalArgumentException("Unknown record type: " + type);
        }
        if (contentLength == 0L && (xtraHeaders == null || xtraHeaders.size() <= 0)) {
            throw new IllegalArgumentException("Cannot write record of content-length zero and base headers only.");
        }
        this.preWriteRecordTasks();
        try {
            String header = this.createRecordHeader(type, url, create14DigitDate, mimetype, recordId, xtraHeaders, contentLength);
            this.write(header.getBytes("UTF-8"));
            if (contentStream != null && contentLength > 0L) {
                this.write(CRLF_BYTES);
                this.copyFrom(contentStream, contentLength, enforceLength);
            }
            this.write(CRLF_BYTES);
            this.write(CRLF_BYTES);
        }
        finally {
            this.postWriteRecordTasks();
        }
    }

    protected URI generateRecordId(Map<String, String> qualifiers) throws IOException {
        URI rid = null;
        try {
            rid = GeneratorFactory.getFactory().getQualifiedRecordID(qualifiers);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        return rid;
    }

    protected URI generateRecordId(String key, String value) throws IOException {
        URI rid = null;
        try {
            rid = GeneratorFactory.getFactory().getQualifiedRecordID(key, value);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        return rid;
    }

    public URI writeWarcinfoRecord(String filename) throws IOException {
        return this.writeWarcinfoRecord(filename, null);
    }

    public URI writeWarcinfoRecord(String filename, String description) throws IOException {
        if (filename.endsWith(".open")) {
            filename = filename.substring(0, filename.length() - ".open".length());
        }
        ANVLRecord record = new ANVLRecord(2);
        record.addLabelValue("WARC-Filename", filename);
        if (description != null && description.length() > 0) {
            record.addLabelValue("Content-Description", description);
        }
        byte[] warcinfoBody = null;
        if (this.fileMetadata == null) {
            warcinfoBody = "TODO: Unimplemented".getBytes();
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Iterator i = this.fileMetadata.iterator();
            while (i.hasNext()) {
                baos.write(i.next().toString().getBytes("UTF-8"));
            }
            warcinfoBody = baos.toByteArray();
        }
        URI uri = this.writeWarcinfoRecord("application/warc-fields", record, new ByteArrayInputStream(warcinfoBody), warcinfoBody.length);
        return uri;
    }

    public URI writeWarcinfoRecord(String mimetype, ANVLRecord namedFields, InputStream fileMetadata, long fileMetadataLength) throws IOException {
        URI recordid = this.generateRecordId("type", "warcinfo");
        this.writeWarcinfoRecord(ArchiveUtils.getLog14Date(), mimetype, recordid, namedFields, fileMetadata, fileMetadataLength);
        return recordid;
    }

    public void writeWarcinfoRecord(String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream fileMetadata, long fileMetadataLength) throws IOException {
        this.writeRecord("warcinfo", null, create14DigitDate, mimetype, recordId, namedFields, fileMetadata, fileMetadataLength, true);
    }

    public void writeRequestRecord(String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream request, long requestLength) throws IOException {
        this.writeRecord("request", url, create14DigitDate, mimetype, recordId, namedFields, request, requestLength, true);
    }

    public void writeResourceRecord(String url, String create14DigitDate, String mimetype, ANVLRecord namedFields, InputStream response, long responseLength) throws IOException {
        this.writeResourceRecord(url, create14DigitDate, mimetype, WARCWriter.getRecordID(), namedFields, response, responseLength);
    }

    public void writeResourceRecord(String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream response, long responseLength) throws IOException {
        this.writeRecord("resource", url, create14DigitDate, mimetype, recordId, namedFields, response, responseLength, true);
    }

    public void writeResponseRecord(String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream response, long responseLength) throws IOException {
        this.writeRecord("response", url, create14DigitDate, mimetype, recordId, namedFields, response, responseLength, true);
    }

    public void writeRevisitRecord(String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream response, long responseLength) throws IOException {
        this.writeRecord("revisit", url, create14DigitDate, mimetype, recordId, namedFields, response, responseLength, false);
    }

    public void writeMetadataRecord(String url, String create14DigitDate, String mimetype, URI recordId, ANVLRecord namedFields, InputStream metadata, long metadataLength) throws IOException {
        this.writeRecord("metadata", url, create14DigitDate, mimetype, recordId, namedFields, metadata, metadataLength, true);
    }

    public static URI getRecordID() throws IOException {
        URI result;
        try {
            result = GeneratorFactory.getFactory().getRecordID();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
        return result;
    }

    static {
        try {
            CRLF_BYTES = "\r\n".getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

