/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.warc.WARCConstants;
import org.archive.io.warc.WARCReader;
import org.archive.io.warc.WARCReaderFactory;
import org.archive.io.warc.WARCRecord;
import org.archive.io.warc.WARCWriter;
import org.archive.uid.GeneratorFactory;
import org.archive.util.ArchiveUtils;
import org.archive.util.TmpDirTestCase;
import org.archive.util.anvl.ANVLRecord;

public class WARCWriterTest
extends TmpDirTestCase
implements WARCConstants {
    private static final AtomicInteger SERIAL_NO = new AtomicInteger();
    private static final String PREFIX = "IAH";
    private static final String SOME_URL = "http://www.archive.org/test/";

    public void testCheckHeaderLineValue() throws Exception {
        WARCWriter writer = new WARCWriter();
        writer.checkHeaderValue("one");
        IOException exception = null;
        try {
            writer.checkHeaderValue("with space");
        }
        catch (IOException e) {
            exception = e;
        }
        WARCWriterTest.assertNotNull((Object)exception);
        exception = null;
        try {
            writer.checkHeaderValue("with\u0000x0000controlcharacter");
        }
        catch (IOException e) {
            exception = e;
        }
        WARCWriterTest.assertNotNull((Object)exception);
    }

    public void testMimetypes() throws IOException {
        WARCWriter writer = new WARCWriter();
        writer.checkHeaderLineMimetypeParameter("text/xml");
        writer.checkHeaderLineMimetypeParameter("text/xml+rdf");
        WARCWriterTest.assertEquals((String)writer.checkHeaderLineMimetypeParameter("text/plain; charset=SHIFT-JIS"), (String)"text/plain; charset=SHIFT-JIS");
        WARCWriterTest.assertEquals((String)writer.checkHeaderLineMimetypeParameter("multipart/mixed; \r\n        boundary=\"simple boundary\""), (String)"multipart/mixed; boundary=\"simple boundary\"");
    }

    public void testWriteRecord() throws IOException {
        File[] files = new File[]{this.getTmpDir()};
        WARCWriter writer = new WARCWriter(SERIAL_NO, Arrays.asList(files), this.getClass().getName(), "suffix", false, -1L, null);
        this.writeFile(writer);
        writer = new WARCWriter(SERIAL_NO, Arrays.asList(files), this.getClass().getName(), "suffix", true, -1L, null);
        this.writeFile(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(WARCWriter writer) throws IOException {
        try {
            this.writeWarcinfoRecord(writer);
            this.writeBasicRecords(writer);
        }
        finally {
            writer.close();
            writer.getFile().delete();
        }
    }

    private void writeWarcinfoRecord(WARCWriter writer) throws IOException {
        ANVLRecord meta = new ANVLRecord();
        meta.addLabelValue("size", "1G");
        meta.addLabelValue("operator", "igor");
        byte[] bytes = meta.getUTF8Bytes();
        writer.writeWarcinfoRecord("application/warc-fields", null, new ByteArrayInputStream(bytes), bytes.length);
    }

    protected void writeBasicRecords(WARCWriter writer) throws IOException {
        ANVLRecord headerFields = new ANVLRecord();
        headerFields.addLabelValue("x", "y");
        headerFields.addLabelValue("a", "b");
        URI rid = null;
        try {
            rid = GeneratorFactory.getFactory().getQualifiedRecordID("type", "metadata");
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        String content = "Any old content.";
        for (int i = 0; i < 10; ++i) {
            String body = i + ". " + "Any old content.";
            byte[] bodyBytes = body.getBytes("UTF-8");
            writer.writeRecord("metadata", "http://www.archive.org/", ArchiveUtils.get14DigitDate(), "no/type", rid, headerFields, new ByteArrayInputStream(bodyBytes), bodyBytes.length, true);
        }
    }

    protected static String getContent() {
        return WARCWriterTest.getContent(null);
    }

    protected static String getContent(String indexStr) {
        String page = indexStr != null ? "Page #" + indexStr : "Some Page";
        return "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<html><head><title>" + page + "</title></head>" + "<body>" + page + "</body></html>";
    }

    protected int writeRandomHTTPRecord(WARCWriter w, int index) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String indexStr = Integer.toString(index);
        byte[] record = WARCWriterTest.getContent(indexStr).getBytes();
        int recordLength = record.length;
        baos.write(record);
        ANVLRecord r = new ANVLRecord(1);
        r.addLabelValue("IP-Address", "127.0.0.1");
        w.writeResourceRecord("http://www.one.net/id=" + indexStr, ArchiveUtils.get14DigitDate(), "text/html; charset=UTF-8", r, new ByteArrayInputStream(baos.toByteArray()), recordLength);
        return recordLength;
    }

    private File writeRecords(String baseName, boolean compress, int maxSize, int recordCount) throws IOException {
        this.cleanUpOldFiles(baseName);
        File[] files = new File[]{this.getTmpDir()};
        WARCWriter w = new WARCWriter(SERIAL_NO, Arrays.asList(files), baseName + '-' + PREFIX, "", compress, (long)maxSize, null);
        WARCWriterTest.assertNotNull((Object)w);
        for (int i = 0; i < recordCount; ++i) {
            this.writeRandomHTTPRecord(w, i);
        }
        w.close();
        WARCWriterTest.assertTrue((String)("Doesn't exist: " + w.getFile().getAbsolutePath()), (boolean)w.getFile().exists());
        return w.getFile();
    }

    private void validate(File f, int recordCount) throws FileNotFoundException, IOException {
        WARCReader reader = WARCReaderFactory.get(f);
        WARCWriterTest.assertNotNull((Object)reader);
        List<ArchiveRecordHeader> headers = null;
        headers = recordCount == -1 ? reader.validate() : reader.validate(recordCount);
        reader.close();
        reader = WARCReaderFactory.get(f);
        for (int i = headers.size() - 1; i >= 0; --i) {
            ArchiveRecordHeader h = headers.get(i);
            ArchiveRecord r = reader.get(h.getOffset());
            String mimeType = r.getHeader().getMimetype();
            WARCWriterTest.assertTrue((String)"Record is bogus", (mimeType != null && mimeType.length() > 0 ? 1 : 0) != 0);
        }
        reader.close();
        WARCWriterTest.assertTrue((String)"Metadatas not equal", (headers.size() == recordCount ? 1 : 0) != 0);
        for (ArchiveRecordHeader r : headers) {
            WARCWriterTest.assertTrue((String)"Record is empty", (r.getLength() > 0L ? 1 : 0) != 0);
        }
    }

    public void testWriteRecords() throws IOException {
        int recordCount = 2;
        File f = this.writeRecords("writeRecord", false, 0x40000000, 2);
        this.validate(f, 3);
    }

    public void testRandomAccess() throws IOException {
        int recordCount = 3;
        File f = this.writeRecords("writeRecord", true, 0x40000000, 3);
        WARCReader reader = WARCReaderFactory.get(f);
        boolean readFirst = false;
        String url = null;
        long offset = -1L;
        long totalRecords = 0L;
        boolean readSecond = false;
        for (WARCRecord ar : reader) {
            if (!readFirst) {
                readFirst = true;
            } else if (!readSecond) {
                url = ar.getHeader().getUrl();
                offset = ar.getHeader().getOffset();
                readSecond = true;
            }
            ++totalRecords;
        }
        reader = WARCReaderFactory.get(f, offset);
        ArchiveRecord ar = reader.get();
        WARCWriterTest.assertEquals((String)ar.getHeader().getUrl(), (String)url);
        ar.close();
        reader = WARCReaderFactory.get(f, offset);
        int count = 0;
        Iterator<ArchiveRecord> i = reader.iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        reader.close();
        WARCWriterTest.assertEquals((long)(totalRecords - 1L), (long)count);
    }

    public void testWriteRecordCompressed() throws IOException {
        int recordCount = 2;
        File arcFile = this.writeRecords("writeRecordCompressed", true, 0x40000000, 2);
        this.validate(arcFile, 3);
    }

    protected WARCWriter createWARCWriter(String NAME, boolean compress) {
        File[] files = new File[]{this.getTmpDir()};
        return new WARCWriter(SERIAL_NO, Arrays.asList(files), NAME, "", compress, 0x40000000L, null);
    }

    protected static ByteArrayOutputStream getBaos(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(str.getBytes());
        return baos;
    }

    protected static void writeRecord(WARCWriter w, String url, String mimetype, int len, ByteArrayOutputStream baos) throws IOException {
        w.writeResourceRecord(url, ArchiveUtils.get14DigitDate(), mimetype, null, new ByteArrayInputStream(baos.toByteArray()), len);
    }

    protected int iterateRecords(WARCReader r) throws IOException {
        int count = 0;
        for (ArchiveRecord ar : r) {
            ar.close();
            if (count != 0) {
                WARCWriterTest.assertTrue((String)("Unexpected URL " + ar.getHeader().getUrl()), (boolean)ar.getHeader().getUrl().equals(SOME_URL));
            }
            ++count;
        }
        return count;
    }

    protected WARCWriter createWithOneRecord(String name, boolean compressed) throws IOException {
        WARCWriter writer = this.createWARCWriter(name, compressed);
        String content = WARCWriterTest.getContent();
        WARCWriterTest.writeRecord(writer, SOME_URL, "text/html", content.length(), WARCWriterTest.getBaos(content));
        return writer;
    }

    public void testSpaceInURL() {
        String eMessage = null;
        try {
            this.holeyUrl("testSpaceInURL-IAH", false, " ");
        }
        catch (IOException e) {
            eMessage = e.getMessage();
        }
        WARCWriterTest.assertTrue((String)("Didn't get expected exception: " + eMessage), (boolean)eMessage.startsWith("Contains disallowed"));
    }

    public void testTabInURL() {
        String eMessage = null;
        try {
            this.holeyUrl("testTabInURL-IAH", false, "\t");
        }
        catch (IOException e) {
            eMessage = e.getMessage();
        }
        WARCWriterTest.assertTrue((String)("Didn't get expected exception: " + eMessage), (boolean)eMessage.startsWith("Contains illegal"));
    }

    protected void holeyUrl(String name, boolean compress, String urlInsert) throws IOException {
        WARCWriter writer = this.createWithOneRecord(name, compress);
        String content = WARCWriterTest.getContent();
        ByteArrayOutputStream baos = WARCWriterTest.getBaos(content);
        WARCWriterTest.writeRecord(writer, SOME_URL + urlInsert + "/index.html", "text/html", content.length(), baos);
        writer.close();
    }

    public static File createWARCFile(File arcdir, boolean compress) throws IOException {
        File[] files = new File[]{arcdir};
        WARCWriter writer = new WARCWriter(SERIAL_NO, Arrays.asList(files), "test", "", compress, 0x40000000L, null);
        String content = WARCWriterTest.getContent();
        WARCWriterTest.writeRecord(writer, SOME_URL, "text/html", content.length(), WARCWriterTest.getBaos(content));
        writer.close();
        return writer.getFile();
    }

    public void testArcRecordOffsetReads() throws Exception {
        WARCWriter w = this.createWithOneRecord("testArcRecordInBufferStream", true);
        w.close();
        WARCReader r = WARCReaderFactory.get(w.getFile());
        Iterator<ArchiveRecord> i = r.iterator();
        ArchiveRecord ar = i.next();
        i.hasNext();
        ar = (WARCRecord)i.next();
        byte[] buffer = new byte[17];
        int maxRead = 4;
        int totalRead = 0;
        while (totalRead < 4) {
            WARCWriterTest.assertTrue(((totalRead += ar.read(buffer, 13 + totalRead, 4 - totalRead)) > 0 ? 1 : 0) != 0);
        }
    }
}

